/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Range4D {
    public int dimensionId;
    public int xMin;
    public int yMin;
    public int zMin;
    public int xMax;
    public int yMax;
    public int zMax;

    public Range4D(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int dimension) {
        this.xMin = minX;
        this.yMin = minY;
        this.zMin = minZ;
        this.xMax = maxX;
        this.yMax = maxY;
        this.zMax = maxZ;
        this.dimensionId = dimension;
    }

    public Range4D(Chunk3D chunk) {
        this.xMin = chunk.xCoord * 16;
        this.yMin = 0;
        this.zMin = chunk.zCoord * 16;
        this.xMax = this.xMin + 16;
        this.yMax = 255;
        this.zMax = this.zMin + 16;
        this.dimensionId = chunk.dimensionId;
    }

    public Range4D(Coord4D coord) {
        this.xMin = coord.xCoord;
        this.yMin = coord.yCoord;
        this.zMin = coord.zCoord;
        this.xMax = coord.xCoord + 1;
        this.yMax = coord.yCoord + 1;
        this.zMax = coord.zCoord + 1;
        this.dimensionId = coord.dimensionId;
    }

    public static Range4D getChunkRange(EntityPlayer player) {
        int radius = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72395_o();
        return new Range4D(new Chunk3D((Entity)player)).expandChunks(radius);
    }

    public Range4D expandChunks(int chunks) {
        this.xMin -= chunks * 16;
        this.xMax += chunks * 16;
        this.zMin -= chunks * 16;
        this.zMax += chunks * 16;
        return this;
    }

    public Range4D expandFromCenter(int radius) {
        this.xMin -= radius;
        this.xMax += radius;
        this.zMin -= radius;
        this.zMax += radius;
        return this;
    }

    public Set<Chunk3D> getIntersectingChunks() {
        HashSet<Chunk3D> set = new HashSet<Chunk3D>();
        for (int chunkX = this.xMin >> 4; chunkX <= this.xMax - 1 >> 4; ++chunkX) {
            for (int chunkZ = this.zMin >> 4; chunkZ <= this.zMax - 1 >> 4; ++chunkZ) {
                set.add(new Chunk3D(chunkX, chunkZ, this.dimensionId));
            }
        }
        return set;
    }

    public boolean intersects(Range4D range) {
        return (double)(this.xMax + 1) - 1.0E-5 > (double)range.xMin && (double)(range.xMax + 1) - 1.0E-5 > (double)this.xMin && (double)(this.yMax + 1) - 1.0E-5 > (double)range.yMin && (double)(range.yMax + 1) - 1.0E-5 > (double)this.yMin && (double)(this.zMax + 1) - 1.0E-5 > (double)range.zMin && (double)(range.zMax + 1) - 1.0E-5 > (double)this.zMin;
    }

    public Range4D clone() {
        return new Range4D(this.xMin, this.yMin, this.zMin, this.xMax, this.yMax, this.zMax, this.dimensionId);
    }

    public String toString() {
        return "[Range4D: " + this.xMin + ", " + this.yMin + ", " + this.zMin + ", " + this.xMax + ", " + this.yMax + ", " + this.zMax + ", dim=" + this.dimensionId + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Range4D && ((Range4D)obj).xMin == this.xMin && ((Range4D)obj).yMin == this.yMin && ((Range4D)obj).zMin == this.zMin && ((Range4D)obj).xMax == this.xMax && ((Range4D)obj).yMax == this.yMax && ((Range4D)obj).zMax == this.zMax && ((Range4D)obj).dimensionId == this.dimensionId;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.xMin;
        code = 31 * code + this.yMin;
        code = 31 * code + this.zMin;
        code = 31 * code + this.xMax;
        code = 31 * code + this.yMax;
        code = 31 * code + this.zMax;
        code = 31 * code + this.dimensionId;
        return code;
    }
}

