/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.HashMap;
import mekanism.common.Mekanism;
import mekanism.common.util.RecipeUtils;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedMekanismRecipe
implements IRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private ItemStack output = null;
    private Object[] input = null;
    public int width = 0;
    public int height = 0;
    private boolean mirrored = true;

    public ShapedMekanismRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped Mekanism recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                String ret = "Invalid shaped Mekanism recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return RecipeUtils.getCraftingResult(inv, this.output.func_77946_l());
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, true)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (RecipeUtils.areItemsEqualForCrafting((ItemStack)target, slot)) continue;
                    return false;
                }
                if (target instanceof Iterable) {
                    boolean matched = false;
                    for (ItemStack item : (Iterable)target) {
                        matched = matched || RecipeUtils.areItemsEqualForCrafting(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedMekanismRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    public static ShapedMekanismRecipe create(NBTTagCompound nbtTags) {
        if (!nbtTags.func_74764_b("result") || !nbtTags.func_74764_b("input")) {
            Mekanism.logger.error("[Mekanism] Shaped recipe parse error: missing input or result compound tag.");
            return null;
        }
        ItemStack result = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("result"));
        NBTTagList list = nbtTags.func_150295_c("input", 10);
        if (result == null || list.func_74745_c() == 0) {
            Mekanism.logger.error("[Mekanism] Shaped recipe parse error: invalid result stack or input data list.");
            return null;
        }
        Object[] ret = new Object[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            if (compound.func_74764_b("oredict")) {
                ret[i] = compound.func_74779_i("oredict");
                continue;
            }
            if (compound.func_74764_b("pattern")) {
                ret[i] = compound.func_74779_i("pattern");
                continue;
            }
            if (compound.func_74764_b("character")) {
                String s = compound.func_74779_i("character");
                if (s.length() > 1) {
                    Mekanism.logger.error("[Mekanism] Shaped recipe parse error: invalid pattern character data.");
                    return null;
                }
                ret[i] = Character.valueOf(compound.func_74779_i("character").toCharArray()[0]);
                continue;
            }
            if (compound.func_74764_b("itemstack")) {
                ret[i] = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("itemstack"));
                continue;
            }
            Mekanism.logger.error("[Mekanism] Shaped recipe parse error: invalid input tag data key.");
            return null;
        }
        return new ShapedMekanismRecipe(result, ret);
    }
}

