/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.base.IActiveState;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.StackSearcher;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityLogisticalSorter
extends TileEntityElectricBlock
implements IRedstoneControl,
IActiveState,
IConfigCardAccess.ISpecialConfigData,
ISustainedData,
ISecurityTile {
    public HashList<TransporterFilter> filters = new HashList();
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public EnumColor color;
    public boolean autoEject;
    public boolean roundRobin;
    public int rrIndex = 0;
    public final int MAX_DELAY = 10;
    public int delayTicks;
    public boolean isActive;
    public boolean clientActive;
    public final double ENERGY_PER_ITEM = 5.0;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityLogisticalSorter() {
        super("LogisticalSorter", BlockStateMachine.MachineType.LOGISTICAL_SORTER.baseEnergy);
        this.inventory = new ItemStack[1];
        this.doAutoSync = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.delayTicks = Math.max(0, this.delayTicks - 1);
            if (this.delayTicks == 6) {
                this.setActive(false);
            }
            if (MekanismUtils.canFunction(this) && this.delayTicks == 0) {
                TileEntity back = Coord4D.get(this).offset(this.facing.func_176734_d()).getTileEntity((IBlockAccess)this.field_145850_b);
                TileEntity front = Coord4D.get(this).offset(this.facing).getTileEntity((IBlockAccess)this.field_145850_b);
                if (back instanceof IInventory && (front != null && CapabilityUtils.hasCapability((ICapabilityProvider)front, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this.facing.func_176734_d()) || front instanceof IInventory)) {
                    ItemStack used;
                    InvStack invStack;
                    IInventory inventory = InventoryUtils.checkChestInv((IInventory)back);
                    boolean sentItems = false;
                    int min = 0;
                    block0: for (TransporterFilter filter : this.filters) {
                        InvStack invStack2;
                        StackSearcher search = new StackSearcher(inventory, this.facing.func_176734_d());
                        while (search.i >= 0 && (invStack2 = filter.getStackFromInventory(search)) != null && invStack2.getStack() != null) {
                            ItemStack used2;
                            if (!filter.canFilter(invStack2.getStack())) continue;
                            if (filter instanceof TItemStackFilter) {
                                TItemStackFilter itemFilter = (TItemStackFilter)filter;
                                if (itemFilter.sizeMode) {
                                    min = itemFilter.min;
                                }
                            }
                            if ((used2 = this.emitItemToTransporter(front, invStack2, filter.color, min)) == null) continue;
                            invStack2.use(used2.field_77994_a);
                            inventory.func_70296_d();
                            this.setActive(true);
                            sentItems = true;
                            break block0;
                        }
                    }
                    if (!sentItems && this.autoEject && (invStack = InventoryUtils.takeTopStack(inventory, this.facing.func_176734_d(), new Finder.FirstFinder())) != null && invStack.getStack() != null && (used = this.emitItemToTransporter(front, invStack, this.color, 0)) != null) {
                        invStack.use(used.field_77994_a);
                        inventory.func_70296_d();
                        this.setActive(true);
                    }
                    this.delayTicks = 10;
                }
            }
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getGenericPacket(new ArrayList<Object>())), (EntityPlayerMP)player);
                }
            }
        }
    }

    public ItemStack emitItemToTransporter(TileEntity front, InvStack inInventory, EnumColor filterColor, int min) {
        ItemStack used = null;
        if (CapabilityUtils.hasCapability((ICapabilityProvider)front, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this.facing.func_176734_d())) {
            ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)front, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, this.facing.func_176734_d());
            if (!this.roundRobin) {
                ItemStack rejects = TransporterUtils.insert(this, transporter, inInventory.getStack(), filterColor, true, min);
                if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                    used = TransporterManager.getToUse(inInventory.getStack(), rejects);
                }
            } else {
                ItemStack rejects = TransporterUtils.insertRR(this, transporter, inInventory.getStack(), filterColor, true, min);
                if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                    used = TransporterManager.getToUse(inInventory.getStack(), rejects);
                }
            }
        } else if (front instanceof IInventory) {
            ItemStack rejects = InventoryUtils.putStackInInventory((IInventory)front, inInventory.getStack(), this.facing, false);
            if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                used = TransporterManager.getToUse(inInventory.getStack(), rejects);
            }
        }
        return used;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74757_a("autoEject", this.autoEject);
        nbtTags.func_74757_a("roundRobin", this.roundRobin);
        nbtTags.func_74768_a("rrIndex", this.rrIndex);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.autoEject = nbtTags.func_74767_n("autoEject");
        this.roundRobin = nbtTags.func_74767_n("roundRobin");
        this.rrIndex = nbtTags.func_74762_e("rrIndex");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        block19: {
            int type;
            block21: {
                block20: {
                    if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                        int type2 = dataStream.readInt();
                        if (type2 == 0) {
                            int clickType = dataStream.readInt();
                            if (clickType == 0) {
                                this.color = TransporterUtils.increment(this.color);
                            } else if (clickType == 1) {
                                this.color = TransporterUtils.decrement(this.color);
                            } else if (clickType == 2) {
                                this.color = null;
                            }
                        } else if (type2 == 1) {
                            this.autoEject = !this.autoEject;
                        } else if (type2 == 2) {
                            this.roundRobin = !this.roundRobin;
                            this.rrIndex = 0;
                        } else if (type2 == 3) {
                            int filterIndex = dataStream.readInt();
                            this.filters.swap(filterIndex, filterIndex - 1);
                            for (EntityPlayer player : this.playersUsing) {
                                this.func_174889_b(player);
                            }
                        } else if (type2 == 4) {
                            int filterIndex = dataStream.readInt();
                            this.filters.swap(filterIndex, filterIndex + 1);
                            for (EntityPlayer player : this.playersUsing) {
                                this.func_174889_b(player);
                            }
                        }
                        return;
                    }
                    super.handlePacketData(dataStream);
                    if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) break block19;
                    type = dataStream.readInt();
                    if (type != 0) break block20;
                    this.clientActive = dataStream.readBoolean();
                    this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
                    int c = dataStream.readInt();
                    this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
                    this.autoEject = dataStream.readBoolean();
                    this.roundRobin = dataStream.readBoolean();
                    this.filters.clear();
                    int amount = dataStream.readInt();
                    for (int i = 0; i < amount; ++i) {
                        this.filters.add(TransporterFilter.readFromPacket(dataStream));
                    }
                    break block19;
                }
                if (type != 1) break block21;
                this.clientActive = dataStream.readBoolean();
                this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
                int c = dataStream.readInt();
                this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
                this.autoEject = dataStream.readBoolean();
                this.roundRobin = dataStream.readBoolean();
                break block19;
            }
            if (type != 2) break block19;
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(TransporterFilter.readFromPacket(dataStream));
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.autoEject);
        data.add(this.roundRobin);
        data.add(this.filters.size());
        for (TransporterFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public ArrayList getGenericPacket(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.autoEject);
        data.add(this.roundRobin);
        return data;
    }

    public ArrayList getFilterPacket(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (TransporterFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public boolean canSendHome(ItemStack stack) {
        TileEntity back = Coord4D.get(this).offset(this.facing.func_176734_d()).getTileEntity((IBlockAccess)this.field_145850_b);
        if (back instanceof IInventory) {
            return InventoryUtils.canInsert(back, null, stack, this.facing.func_176734_d(), true);
        }
        return false;
    }

    public boolean hasInventory() {
        return Coord4D.get(this).offset(this.facing.func_176734_d()).getTileEntity((IBlockAccess)this.field_145850_b) instanceof IInventory;
    }

    public ItemStack sendHome(ItemStack stack) {
        TileEntity back = Coord4D.get(this).offset(this.facing.func_176734_d()).getTileEntity((IBlockAccess)this.field_145850_b);
        if (back instanceof IInventory) {
            return InventoryUtils.putStackInInventory((IInventory)back, stack, this.facing.func_176734_d(), true);
        }
        return stack;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == this.facing || side == this.facing.func_176734_d()) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getFilterPacket(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
            if (active && MekanismConfig.client.enableMachineSounds) {
                this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), MekanismSounds.CLICK, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public EnumSet<EnumFacing> getConsumingSides() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public boolean canSetFacing(int facing) {
        return true;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74757_a("autoEject", this.autoEject);
        nbtTags.func_74757_a("roundRobin", this.roundRobin);
        nbtTags.func_74768_a("rrIndex", this.rrIndex);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.autoEject = nbtTags.func_74767_n("autoEject");
        this.roundRobin = nbtTags.func_74767_n("roundRobin");
        this.rrIndex = nbtTags.func_74762_e("rrIndex");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setBoolean(itemStack, "hasSorterConfig", true);
        if (this.color != null) {
            ItemDataUtils.setInt(itemStack, "color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        ItemDataUtils.setBoolean(itemStack, "autoEject", this.autoEject);
        ItemDataUtils.setBoolean(itemStack, "roundRobin", this.roundRobin);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "hasSorterConfig")) {
            if (ItemDataUtils.hasData(itemStack, "color")) {
                this.color = TransporterUtils.colors.get(ItemDataUtils.getInt(itemStack, "color"));
            }
            this.autoEject = ItemDataUtils.getBoolean(itemStack, "autoEject");
            this.roundRobin = ItemDataUtils.getBoolean(itemStack, "roundRobin");
            if (ItemDataUtils.hasData(itemStack, "filters")) {
                NBTTagList tagList = ItemDataUtils.getList(itemStack, "filters");
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    this.filters.add(TransporterFilter.readFromNBT(tagList.func_150305_b(i)));
                }
            }
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }
}

