/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix;

import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.foamfix.util.PretendPackageMap;

public class ProxyCommon {
    private void optimizeLaunchWrapper() {
        LaunchClassLoader loader = (LaunchClassLoader)this.getClass().getClassLoader();
        Field resourceCacheField = ReflectionHelper.findField(LaunchClassLoader.class, (String[])new String[]{"resourceCache"});
        Field packageManifestsField = ReflectionHelper.findField(LaunchClassLoader.class, (String[])new String[]{"packageManifests"});
        if (FoamFixShared.config.lwWeakenResourceCache) {
            FoamFix.logger.info("Weakening LaunchWrapper resource cache...");
            try {
                Map oldResourceCache = (Map)resourceCacheField.get(loader);
                ConcurrentMap newResourceCache = CacheBuilder.newBuilder().weakValues().build().asMap();
                newResourceCache.putAll(oldResourceCache);
                resourceCacheField.set(loader, newResourceCache);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (FoamFixShared.config.lwDummyPackageManifestMap) {
            FoamFix.logger.info("Dummying out LaunchWrapper's unused package manifests...");
            try {
                packageManifestsField.set(loader, new PretendPackageMap());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void preInit() {
    }

    public void init() {
    }

    public void postInit() {
        this.optimizeLaunchWrapper();
    }
}

