/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import gnu.trove.set.hash.TCustomHashSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Logger;
import pl.asie.foamfix.client.DeduplicatingStorage;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.foamfix.util.HashingStrategies;

public class Deduplicator {
    private static final Set<Class> BLACKLIST_CLASS = new HashSet<Class>();
    private static final Map<Class, Set<Field>> CLASS_FIELDS = new HashMap<Class, Set<Field>>();
    private static final Field FIELD_UNPACKED_DATA = ReflectionHelper.findField(UnpackedBakedQuad.class, (String[])new String[]{"unpackedData"});
    private static final Field FIELD_VERTEX_DATA = ReflectionHelper.findField(BakedQuad.class, (String[])new String[]{"vertexData", "field_178215_a"});
    public int successfuls = 0;
    public int maxRecursion = 0;
    private DeduplicatingStorage<float[]> FLOATA_STORAGE = new DeduplicatingStorage<float[]>(HashingStrategies.FLOAT_ARRAY);
    private DeduplicatingStorage<float[][]> FLOATAA_STORAGE = new DeduplicatingStorage<float[][]>(HashingStrategies.FLOAT_ARRAY_ARRAY);
    private DeduplicatingStorage OBJECT_STORAGE = new DeduplicatingStorage(HashingStrategies.GENERIC);
    private DeduplicatingStorage<ItemCameraTransforms> ICT_STORAGE = new DeduplicatingStorage<ItemCameraTransforms>(HashingStrategies.ITEM_CAMERA_TRANSFORMS);
    private Set<Object> deduplicatedObjects = new TCustomHashSet(HashingStrategies.IDENTITY);

    public void addObjectsToObjectStorage(Collection<Object> coll) {
        this.OBJECT_STORAGE.addAll(coll);
    }

    public Object deduplicate0(Object o) {
        Class<?> c = o.getClass();
        Object n = o;
        if (float[].class.isAssignableFrom(c)) {
            n = this.FLOATA_STORAGE.deduplicate((float[])o);
        } else if (ResourceLocation.class == c || TRSRTransformation.class == c) {
            n = this.OBJECT_STORAGE.deduplicate(o);
        } else if (ItemCameraTransforms.class == c) {
            n = this.ICT_STORAGE.deduplicate((ItemCameraTransforms)o);
        } else if (float[][].class.isAssignableFrom(c)) {
            float[][] arr = this.FLOATAA_STORAGE.deduplicate((float[][])o);
            if (arr != o) {
                n = arr;
                this.successfuls += arr.length;
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (float[])this.deduplicate0(arr[i]);
                }
            }
        } else if (float[][][].class.isAssignableFrom(c)) {
            float[][][] arr = (float[][][])o;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (float[][])this.deduplicate0(arr[i]);
            }
        } else {
            return null;
        }
        if (n != o) {
            ++this.successfuls;
        }
        return n;
    }

    public Object deduplicateObject(Object o, int recursion) {
        if (o == null || recursion > this.maxRecursion) {
            return o;
        }
        Class<?> c = o.getClass();
        if (BLACKLIST_CLASS.contains(c) || this.deduplicatedObjects.contains(o)) {
            return o;
        }
        this.deduplicatedObjects.add(o);
        if (o instanceof UnpackedBakedQuad && !FoamFixShared.enabledCoremodDeduplicator) {
            try {
                float[][][] array = (float[][][])FIELD_UNPACKED_DATA.get(o);
                FIELD_UNPACKED_DATA.set(o, this.deduplicate0(array));
            }
            catch (IllegalAccessException array) {}
        } else if (!(o instanceof BakedQuad)) {
            if (o instanceof ResourceLocation || o instanceof TRSRTransformation || c == ItemCameraTransforms.class) {
                return this.deduplicate0(o);
            }
            if (o instanceof Item || o instanceof Block || o instanceof World || o instanceof Entity || o instanceof Logger || o instanceof IRegistry || c.isPrimitive() || c.isEnum()) {
                BLACKLIST_CLASS.add(c);
            } else if (o instanceof Optional) {
                Object b;
                Optional opt = (Optional)o;
                if (opt.isPresent() && (b = this.deduplicateObject(opt.get(), recursion + 1)) != null && b != opt.get()) {
                    return Optional.of((Object)b);
                }
            } else if (o instanceof ImmutableList) {
                ImmutableList il = (ImmutableList)o;
                ArrayList<Object> newList = new ArrayList<Object>();
                boolean deduplicated = false;
                for (int i = 0; i < il.size(); ++i) {
                    Object a = il.get(i);
                    Object b = this.deduplicateObject(a, recursion + 1);
                    newList.add(b != null ? b : a);
                    if (b == null || b == a) continue;
                    deduplicated = true;
                }
                if (deduplicated) {
                    return ImmutableList.copyOf(newList);
                }
            } else if (o instanceof ImmutableMap) {
                ImmutableMap im = (ImmutableMap)o;
                HashMap newMap = new HashMap();
                boolean deduplicated = false;
                UnmodifiableIterator i = im.keySet().iterator();
                while (i.hasNext()) {
                    Object key;
                    Object a = im.get(key = i.next());
                    Object b = this.deduplicateObject(a, recursion + 1);
                    newMap.put(key, b != null ? b : a);
                    if (b == null || b == a) continue;
                    deduplicated = true;
                }
                if (deduplicated) {
                    return ImmutableMap.copyOf(newMap);
                }
            } else if (Map.class.isAssignableFrom(c)) {
                for (Object key : ((Map)o).keySet()) {
                    Object value = ((Map)o).get(key);
                    Object valueD = this.deduplicateObject(value, recursion + 1);
                    if (valueD == null || value == valueD) continue;
                    ((Map)o).put(key, valueD);
                }
            } else if (Collection.class.isAssignableFrom(c)) {
                Iterator i = ((Collection)o).iterator();
                while (i.hasNext()) {
                    this.deduplicateObject(i.next(), recursion + 1);
                }
            } else if (CLASS_FIELDS.containsKey(c)) {
                for (Field f : CLASS_FIELDS.get(c)) {
                    try {
                        Object value = f.get(o);
                        Object valueD = this.deduplicateObject(value, recursion + 1);
                        if (valueD == null || value == valueD) continue;
                        f.set(o, valueD);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            } else {
                HashSet<Field> fieldSet = new HashSet<Field>();
                Class<?> cc = c;
                do {
                    for (Field f : cc.getDeclaredFields()) {
                        f.setAccessible(true);
                        fieldSet.add(f);
                        try {
                            Object value = f.get(o);
                            Object valueD = this.deduplicateObject(value, recursion + 1);
                            if (valueD == null || value == valueD) continue;
                            f.set(o, valueD);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                } while ((cc = cc.getSuperclass()) != Object.class);
                CLASS_FIELDS.put(c, fieldSet);
            }
        }
        return o;
    }

    static {
        BLACKLIST_CLASS.add(Class.class);
        BLACKLIST_CLASS.add(String.class);
        BLACKLIST_CLASS.add(Integer.class);
        BLACKLIST_CLASS.add(Long.class);
        BLACKLIST_CLASS.add(Byte.class);
        BLACKLIST_CLASS.add(Boolean.class);
        BLACKLIST_CLASS.add(Float.class);
        BLACKLIST_CLASS.add(Double.class);
        BLACKLIST_CLASS.add(Short.class);
        BLACKLIST_CLASS.add(TextureAtlasSprite.class);
        BLACKLIST_CLASS.add(ItemStack.class);
        BLACKLIST_CLASS.add(ModelRotation.class);
        BLACKLIST_CLASS.add(Gson.class);
        BLACKLIST_CLASS.add(ModelLoader.class);
        BLACKLIST_CLASS.add(Class.class);
        BLACKLIST_CLASS.add(BlockPart.class);
    }
}

