/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod;

import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.foamfix.coremod.BlockPosPatch;
import pl.asie.foamfix.shared.FoamFixShared;

public class FoamFixTransformer
implements IClassTransformer {
    public byte[] spliceMethods(byte[] data, String className, String targetClassName, String ... methods) {
        HashSet methodSet = Sets.newHashSet((Object[])methods);
        try {
            byte[] dataSplice = ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class"));
            ClassReader readerData = new ClassReader(data);
            ClassReader readerSplice = new ClassReader(dataSplice);
            ClassWriter writer = new ClassWriter(8);
            final String className2 = className.replace('.', '/');
            final String targetClassName2 = targetClassName.replace('.', '/');
            Remapper remapper = new Remapper(){

                public String map(String name) {
                    return className2.equals(name) ? targetClassName2 : name;
                }
            };
            ClassNode nodeData = new ClassNode();
            ClassNode nodeSplice = new ClassNode();
            readerData.accept((ClassVisitor)nodeData, 8);
            readerSplice.accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)nodeSplice, remapper), 8);
            for (int i = 0; i < nodeSplice.methods.size(); ++i) {
                if (!methodSet.contains(((MethodNode)nodeSplice.methods.get((int)i)).name)) continue;
                MethodNode mn = (MethodNode)nodeSplice.methods.get(i);
                boolean added = false;
                for (int j = 0; j < nodeData.methods.size(); ++j) {
                    if (!((MethodNode)nodeData.methods.get((int)j)).name.equals(mn.name) || !((MethodNode)nodeData.methods.get((int)j)).desc.equals(mn.desc)) continue;
                    System.out.println("Spliced in: " + targetClassName + "." + mn.name);
                    nodeData.methods.set(j, mn);
                    added = true;
                    break;
                }
                if (added) continue;
                System.out.println("Added: " + targetClassName + "." + mn.name);
                nodeData.methods.add(mn);
                added = true;
            }
            nodeData.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] transform(String name, String transformedName, byte[] dataOrig) {
        byte[] data = dataOrig;
        if (FoamFixShared.config.geBlockPosPatch) {
            data = "net.minecraft.util.math.Vec3i".equals(transformedName) ? BlockPosPatch.patchVec3i(data) : BlockPosPatch.patchOtherClass(data, "net.minecraft.util.math.BlockPos$MutableBlockPos".equals(transformedName));
        }
        if (FoamFixShared.enabledCoremodDeduplicator && FoamFixShared.config.clDeduplicate && "net.minecraftforge.client.model.pipeline.UnpackedBakedQuad".equals(transformedName)) {
            data = this.spliceMethods(data, "pl.asie.foamfix.coremod.CachingUnpackedBakedQuad", transformedName, "<init>");
        }
        return data;
    }
}

