/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import java.util.EnumSet;
import mcmultipart.client.multipart.IMultipartColor;
import mcmultipart.client.multipart.MultipartRegistryClient;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipart2;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PartState {
    public final IBlockState state;
    public final IBlockState extendedState;
    public final EnumSet<BlockRenderLayer> renderLayers;
    public final ResourceLocation modelPath;
    public final IMultipartColor colorProvider;

    public PartState(IBlockState state, IBlockState extendedState, EnumSet<BlockRenderLayer> renderLayers, ResourceLocation modelPath, IMultipartColor colorProvider) {
        this.state = state;
        this.extendedState = extendedState;
        this.renderLayers = renderLayers;
        this.modelPath = modelPath;
        this.colorProvider = colorProvider;
    }

    @Deprecated
    public static PartState fromPart(IMultipart part) {
        ResourceLocation path = part.getModelPath();
        if (path == null) {
            return null;
        }
        EnumSet<BlockRenderLayer> renderLayers = EnumSet.noneOf(BlockRenderLayer.class);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (!part.canRenderInLayer(layer)) continue;
            renderLayers.add(layer);
        }
        IBlockState state = part.getActualState(MultipartRegistry.getDefaultState(part).func_177621_b());
        IBlockState extendedState = part.getExtendedState(state);
        return new PartState(state, extendedState, renderLayers, path, MultipartRegistryClient.getColorProvider(part.getType()));
    }

    public static PartState fromPart(IMultipart part, IBlockAccess world, BlockPos pos) {
        ResourceLocation path = part.getModelPath();
        if (path == null) {
            return null;
        }
        EnumSet<BlockRenderLayer> renderLayers = EnumSet.noneOf(BlockRenderLayer.class);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (!part.canRenderInLayer(layer)) continue;
            renderLayers.add(layer);
        }
        IBlockState state = part instanceof IMultipart2 ? ((IMultipart2)part).getActualState(MultipartRegistry.getDefaultState(part).func_177621_b(), world, pos) : part.getActualState(MultipartRegistry.getDefaultState(part).func_177621_b());
        IBlockState extendedState = part instanceof IMultipart2 ? ((IMultipart2)part).getExtendedState(state, world, pos) : part.getExtendedState(state);
        return new PartState(state, extendedState, renderLayers, path, MultipartRegistryClient.getColorProvider(part.getType()));
    }

    public int hashCode() {
        return this.state.hashCode() + (this.renderLayers != null ? this.renderLayers.hashCode() << 7 : 0) + (this.modelPath != null ? this.modelPath.hashCode() << 15 : 0);
    }

    public String toString() {
        return "(state=" + this.state + ", extendedState=" + this.extendedState + ", renderLayers=" + this.renderLayers + ", modelPath=" + this.modelPath + ")";
    }
}

