/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.ctm;

import java.util.EnumMap;
import mekanism.client.render.ctm.CTM;
import mekanism.client.render.ctm.CTMConnections;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ArrayUtils;

public class CTMBlockRenderContext {
    private static final CTMConnections[] CACHED_LOCATIONS = (CTMConnections[])ArrayUtils.removeElements((Object[])CTMConnections.VALUES, (Object[])new CTMConnections[]{CTMConnections.UP_UP, CTMConnections.DOWN_DOWN, CTMConnections.EAST_EAST, CTMConnections.WEST_WEST, CTMConnections.NORTH_NORTH, CTMConnections.SOUTH_SOUTH});
    private EnumMap<EnumFacing, CTM> ctmData = new EnumMap(EnumFacing.class);
    private long data;

    public CTMBlockRenderContext(IBlockAccess world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            CTM ctm = this.createCTM();
            ctm.createSubmapIndices(world, pos, face);
            this.ctmData.put(face, ctm);
        }
        this.data = CTMConnections.getData(world, pos, CACHED_LOCATIONS);
    }

    public CTMBlockRenderContext(long d) {
        this.data = d;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            CTM ctm = this.createCTM();
            ctm.createSubmapIndices(this.data, face);
            this.ctmData.put(face, ctm);
        }
    }

    protected CTM createCTM() {
        return CTM.getInstance();
    }

    public CTM getCTM(EnumFacing face) {
        return this.ctmData.get(face);
    }

    public long serialize() {
        return this.data;
    }
}

