/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.ProxyClient;
import pl.asie.foamfix.client.Deduplicator;
import pl.asie.foamfix.shared.FoamFixShared;

public class FoamFixModelDeduplicate {
    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        if (FoamFixShared.config.clDeduplicate) {
            ProgressManager.ProgressBar bakeBar = ProgressManager.push((String)"FoamFix: deduplicating", (int)event.getModelRegistry().func_148742_b().size());
            if (ProxyClient.deduplicator == null) {
                ProxyClient.deduplicator = new Deduplicator();
            }
            FoamFix.logger.info("Deduplicating models...");
            ProxyClient.deduplicator.maxRecursion = 6;
            for (ModelResourceLocation loc : event.getModelRegistry().func_148742_b()) {
                IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
                String modelName = loc.toString();
                bakeBar.step(String.format("[%s]", modelName));
                try {
                    ProxyClient.deduplicator.deduplicateObject(model, 0);
                }
                catch (Exception exception) {}
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bakeBar);
            FoamFix.logger.info("Deduplicated " + ProxyClient.deduplicator.successfuls + " objects.");
        }
        ProxyClient.deduplicator = null;
        FoamFix.updateRamSaved();
    }
}

