/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.util.Copyable;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayUtils {
    public static String[] arrayToLowercase(String[] array) {
        String[] copy = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = array[i].toLowerCase();
        }
        return copy;
    }

    public static Map<String, String> convertKeyValueArrayToMap(String[] array) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : array) {
            String[] split = entry.split("=");
            map.put(split[0], split[1]);
        }
        return map;
    }

    public static <T> boolean containsKeys(Map<T, ?> map, T ... keys) {
        for (T object : keys) {
            if (map.containsKey(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> void addToArrayFirstNull(T[] array, T value) {
        int nullIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            T v = array[i];
            if (v != null) continue;
            nullIndex = i;
            break;
        }
        if (nullIndex == -1) {
            throw new RuntimeException("Unable to add to array as it is full! Expand it before adding to it!");
        }
        array[nullIndex] = value;
    }

    public static <T> List<T> addAllNoNull(T[] array, List<T> list) {
        for (T value : array) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static <T> boolean isEmpty(T[] array) {
        for (T value : array) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static <T> int countNoNull(T[] array) {
        int counter = 0;
        for (T value : array) {
            if (value == null) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> void fillArray(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            T newValue = value;
            if (value instanceof Copyable) {
                newValue = ((Copyable)value).copy();
            }
            array[i] = newValue;
        }
    }

    public static <I, O> List<O> applyArray(Function<I, O> function, I ... array) {
        ArrayList<Object> finalList = new ArrayList<Object>();
        for (I i : array) {
            finalList.add(function.apply(i));
        }
        return finalList;
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])dst;
            for (int i = destPos; i < destPos + length; ++i) {
                if (c[i] == null) continue;
                oa[i] = c[i].copy();
            }
        }
    }
}

