/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;

public class ColourMultiplier
implements IVertexOperation {
    private static ColourMultiplier instance = new ColourMultiplier(-1);
    public static final int operationIndex = CCRenderState.registerOperation();
    public int colour;

    public static ColourMultiplier instance(int colour) {
        ColourMultiplier.instance.colour = colour;
        return instance;
    }

    public ColourMultiplier(int colour) {
        this.colour = colour;
    }

    @Override
    public boolean load(CCRenderState state) {
        if (this.colour == -1) {
            return false;
        }
        state.pipeline.addDependency(state.colourAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState state) {
        state.colour = ColourRGBA.multiply(state.colour, this.colour);
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

