/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.vec;

import codechicken.lib.math.MathHelper;
import codechicken.lib.util.Copyable;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class Vector3
implements Copyable<Vector3> {
    public static Vector3 zero = new Vector3();
    public static Vector3 one = new Vector3(1.0, 1.0, 1.0);
    public static Vector3 center = new Vector3(0.5, 0.5, 0.5);
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(double d, double d1, double d2) {
        this.x = d;
        this.y = d1;
        this.z = d2;
    }

    public Vector3(Vector3 vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public Vector3(double[] da) {
        this(da[0], da[1], da[2]);
    }

    public Vector3(float[] fa) {
        this(fa[0], fa[1], fa[2]);
    }

    public Vector3(Vec3d vec) {
        this.x = vec.field_72450_a;
        this.y = vec.field_72448_b;
        this.z = vec.field_72449_c;
    }

    public Vector3(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public static Vector3 fromEntity(Entity e) {
        return new Vector3(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public static Vector3 fromEntityCenter(Entity e) {
        return new Vector3(e.field_70165_t, e.field_70163_u - e.func_70033_W() + (double)(e.field_70131_O / 2.0f), e.field_70161_v);
    }

    public static Vector3 fromTile(TileEntity tile) {
        return new Vector3(tile.func_174877_v());
    }

    public static Vector3 fromTileCenter(TileEntity tile) {
        return Vector3.fromTile(tile).add(0.5);
    }

    public static Vector3 fromAxes(double[] da) {
        return new Vector3(da[2], da[0], da[1]);
    }

    public static Vector3 fromAxes(float[] fa) {
        return new Vector3(fa[2], fa[0], fa[1]);
    }

    public Vec3d vec3() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public BlockPos pos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3f vector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    @SideOnly(value=Side.CLIENT)
    public Vector4f vector4f() {
        return new Vector4f((float)this.x, (float)this.y, (float)this.z, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void glVertex() {
        GlStateManager.func_187435_e((float)((float)this.x), (float)((float)this.y), (float)((float)this.z));
    }

    public Vector3 set(double x1, double y1, double z1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        return this;
    }

    public Vector3 set(double d) {
        return this.set(d, d, d);
    }

    public Vector3 set(Vector3 vec) {
        return this.set(vec.x, vec.y, vec.z);
    }

    public Vector3 set(double[] da) {
        return this.set(da[0], da[1], da[2]);
    }

    public Vector3 set(float[] fa) {
        return this.set(fa[0], fa[1], fa[2]);
    }

    public Vector3 add(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
        return this;
    }

    public Vector3 add(double d) {
        return this.add(d, d, d);
    }

    public Vector3 add(Vector3 vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vector3 add(BlockPos pos) {
        return this.add(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Vector3 subtract(double dx, double dy, double dz) {
        this.x -= dx;
        this.y -= dy;
        this.z -= dz;
        return this;
    }

    public Vector3 subtract(double d) {
        return this.subtract(d, d, d);
    }

    public Vector3 subtract(Vector3 vec) {
        return this.subtract(vec.x, vec.y, vec.z);
    }

    public Vector3 subtract(BlockPos pos) {
        return this.subtract(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Deprecated
    public Vector3 sub(Vector3 vec) {
        return this.subtract(vec);
    }

    @Deprecated
    public Vector3 sub(BlockPos pos) {
        return this.subtract(pos);
    }

    public Vector3 multiply(double fx, double fy, double fz) {
        this.x *= fx;
        this.y *= fy;
        this.z *= fz;
        return this;
    }

    public Vector3 multiply(double f) {
        return this.multiply(f, f, f);
    }

    public Vector3 multiply(Vector3 f) {
        return this.multiply(f.x, f.y, f.z);
    }

    public Vector3 divide(double fx, double fy, double fz) {
        this.x /= fx;
        this.y /= fy;
        this.z /= fz;
        return this;
    }

    public Vector3 divide(double f) {
        return this.divide(f, f, f);
    }

    public Vector3 divide(Vector3 vec) {
        return this.divide(vec.x, vec.y, vec.z);
    }

    public Vector3 divide(BlockPos pos) {
        return this.divide(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Vector3 floor() {
        this.x = MathHelper.floor(this.x);
        this.y = MathHelper.floor(this.y);
        this.z = MathHelper.floor(this.z);
        return this;
    }

    public Vector3 celi() {
        this.x = MathHelper.ceil(this.x);
        this.y = MathHelper.ceil(this.y);
        this.z = MathHelper.ceil(this.z);
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double magSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 normalize() {
        double d = this.mag();
        if (d != 0.0) {
            this.multiply(1.0 / d);
        }
        return this;
    }

    public double dotProduct(double x1, double y1, double z1) {
        return x1 * this.x + y1 * this.y + z1 * this.z;
    }

    public double dotProduct(Vector3 vec) {
        double d = vec.x * this.x + vec.y * this.y + vec.z * this.z;
        if (d > 1.0 && d < 1.00001) {
            d = 1.0;
        } else if (d < -1.0 && d > -1.00001) {
            d = -1.0;
        }
        return d;
    }

    public Vector3 crossProduct(Vector3 vec) {
        double d = this.y * vec.z - this.z * vec.y;
        double d1 = this.z * vec.x - this.x * vec.z;
        double d2 = this.x * vec.y - this.y * vec.x;
        this.x = d;
        this.y = d1;
        this.z = d2;
        return this;
    }

    public Vector3 perpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public Vector3 xCrossProduct() {
        double d = this.z;
        double d1 = -this.y;
        this.x = 0.0;
        this.y = d;
        this.z = d1;
        return this;
    }

    public Vector3 zCrossProduct() {
        double d = this.y;
        double d1 = -this.x;
        this.x = d;
        this.y = d1;
        this.z = 0.0;
        return this;
    }

    public Vector3 yCrossProduct() {
        double d = -this.z;
        double d1 = this.x;
        this.x = d;
        this.y = 0.0;
        this.z = d1;
        return this;
    }

    public double scalarProject(Vector3 b) {
        double l = b.mag();
        return l == 0.0 ? 0.0 : this.dotProduct(b) / l;
    }

    public Vector3 project(Vector3 b) {
        double l = b.magSquared();
        if (l == 0.0) {
            this.set(0.0, 0.0, 0.0);
            return this;
        }
        double m = this.dotProduct(b) / l;
        this.set(b).multiply(m);
        return this;
    }

    public Vector3 rotate(double angle, Vector3 axis) {
        Quat.aroundAxis(axis.copy().normalize(), angle).rotate(this);
        return this;
    }

    public Vector3 rotate(Quat rotator) {
        rotator.rotate(this);
        return this;
    }

    public double angle(Vector3 vec) {
        return Math.acos(this.copy().normalize().dotProduct(vec.copy().normalize()));
    }

    public Vector3 YZintercept(Vector3 end, double px) {
        double dx = end.x - this.x;
        double dy = end.y - this.y;
        double dz = end.z - this.z;
        if (dx == 0.0) {
            return null;
        }
        double d = (px - this.x) / dx;
        if (MathHelper.between(-1.0E-5, d, 1.0E-5)) {
            return this;
        }
        if (!MathHelper.between(0.0, d, 1.0)) {
            return null;
        }
        this.x = px;
        this.y += d * dy;
        this.z += d * dz;
        return this;
    }

    public Vector3 XZintercept(Vector3 end, double py) {
        double dx = end.x - this.x;
        double dy = end.y - this.y;
        double dz = end.z - this.z;
        if (dy == 0.0) {
            return null;
        }
        double d = (py - this.y) / dy;
        if (MathHelper.between(-1.0E-5, d, 1.0E-5)) {
            return this;
        }
        if (!MathHelper.between(0.0, d, 1.0)) {
            return null;
        }
        this.x += d * dx;
        this.y = py;
        this.z += d * dz;
        return this;
    }

    public Vector3 XYintercept(Vector3 end, double pz) {
        double dx = end.x - this.x;
        double dy = end.y - this.y;
        double dz = end.z - this.z;
        if (dz == 0.0) {
            return null;
        }
        double d = (pz - this.z) / dz;
        if (MathHelper.between(-1.0E-5, d, 1.0E-5)) {
            return this;
        }
        if (!MathHelper.between(0.0, d, 1.0)) {
            return null;
        }
        this.x += d * dx;
        this.y += d * dy;
        this.z = pz;
        return this;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean isAxial() {
        return this.x == 0.0 ? this.y == 0.0 || this.z == 0.0 : this.y == 0.0 && this.z == 0.0;
    }

    public double getSide(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return this.y;
            }
            case 2: 
            case 3: {
                return this.z;
            }
            case 4: 
            case 5: {
                return this.x;
            }
        }
        throw new IndexOutOfBoundsException("Switch Falloff");
    }

    public Vector3 setSide(int s, double v) {
        switch (s) {
            case 0: 
            case 1: {
                this.y = v;
                break;
            }
            case 2: 
            case 3: {
                this.z = v;
                break;
            }
            case 4: 
            case 5: {
                this.x = v;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Switch Falloff");
            }
        }
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector3)) {
            return false;
        }
        Vector3 v = (Vector3)o;
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public boolean equalsT(Vector3 v) {
        return MathHelper.between(this.x - 1.0E-5, v.x, this.x + 1.0E-5) && MathHelper.between(this.y - 1.0E-5, v.y, this.y + 1.0E-5) && MathHelper.between(this.z - 1.0E-5, v.z, this.z + 1.0E-5);
    }

    @Override
    public Vector3 copy() {
        return new Vector3(this);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Vector3(" + new BigDecimal(this.x, cont) + ", " + new BigDecimal(this.y, cont) + ", " + new BigDecimal(this.z, cont) + ")";
    }

    public Translation translation() {
        return new Translation(this);
    }

    public Vector3 apply(Transformation t) {
        t.apply(this);
        return this;
    }

    public Vector3 $tilde() {
        return this.normalize();
    }

    public Vector3 unary_$tilde() {
        return this.normalize();
    }

    public Vector3 $plus(Vector3 v) {
        return this.add(v);
    }

    public Vector3 $minus(Vector3 v) {
        return this.subtract(v);
    }

    public Vector3 $times(double d) {
        return this.multiply(d);
    }

    public Vector3 $div(double d) {
        return this.multiply(1.0 / d);
    }

    public Vector3 $times(Vector3 v) {
        return this.crossProduct(v);
    }

    public double $dot$times(Vector3 v) {
        return this.dotProduct(v);
    }
}

