/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.shared;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class FoamFixConfig {
    public boolean lwWeakenResourceCache;
    public boolean lwDummyPackageManifestMap;
    public boolean clDeduplicate;
    public boolean clCleanRedundantModelRegistry;
    public boolean geBlockPosPatch;
    public boolean clTextureDoubleBuffering;
    public boolean geDynamicRegistrySizeScaling;
    public int clDeduplicateRecursionLevel;
    private Configuration config;

    public void init(File file, boolean isCoremod) {
        if (this.config == null) {
            this.config = new Configuration(file);
            this.lwDummyPackageManifestMap = this.config.getBoolean("dummyPackageManifestMap", "launchwrapper", true, "Dummy out LaunchWrapper's unused package manifest map. This will only break things if some other mod reflects into the LaunchClassLoader to get the private map, which as far as I know is not the case.");
            this.lwWeakenResourceCache = this.config.getBoolean("weakenResourceCache", "launchwrapper", true, "Weaken LaunchWrapper's byte[] resource cache to make it cleanuppable by the GC. Safe.");
            this.clDeduplicate = this.config.getBoolean("deduplicateModels", "client", true, "Enable deduplication of redundant objects in memory.");
            this.clDeduplicateRecursionLevel = this.config.getInt("deduplicateModelsMaxRecursion", "client", 6, 1, Integer.MAX_VALUE, "The maximum amount of levels of recursion for the deduplication process. Smaller values will deduplicate less data, but make the process run faster.");
            this.clCleanRedundantModelRegistry = this.config.getBoolean("clearDuplicateModelRegistry", "client", true, "Clears the baked models generated in the first pass *before* entering the second pass, instead of *after*. While this doesn't reduce memory usage in-game, it does reduce it noticeably during loading.");
            this.geDynamicRegistrySizeScaling = this.config.getBoolean("dynamicRegistrySizeScaling", "general", true, "Makes large FML registries scale their availability BitSets dynamically, saving ~48MB of RAM.");
            if (isCoremod) {
                this.geBlockPosPatch = this.config.getBoolean("optimizedBlockPos", "experimental", true, "Optimizes BlockPos mutable/immutable getters to run on the same variables, letting them be inlined and thus theoretically increasing performance.");
            }
            this.config.save();
        }
    }
}

