/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.init.ModItems;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.reference.Reference;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.util.LogHelper;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.model.bakery.SimplePerspectiveAwareLayerModelBakery;
import codechicken.lib.model.loader.IBakedModelLoader;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.TransformUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class EnderStorageBakedModelProvider
implements IBakedModelLoader {
    public static final EnderStorageBakedModelProvider INSTANCE = new EnderStorageBakedModelProvider();

    public IBakedModelLoader.IModKeyProvider createKeyProvider() {
        return EnderStorageKeyProvider.INSTANCE;
    }

    public void addTextures(ImmutableList.Builder<ResourceLocation> builder) {
        String pouchLocation = Reference.MOD_PREFIX + "items/pouch/";
        builder.add((Object)new ResourceLocation(pouchLocation + "closed"));
        builder.add((Object)new ResourceLocation(pouchLocation + "open"));
        builder.add((Object)new ResourceLocation(pouchLocation + "owned_closed"));
        builder.add((Object)new ResourceLocation(pouchLocation + "owned_open"));
        builder.addAll(this.addAllColours(pouchLocation + "buttons/left/"));
        builder.addAll(this.addAllColours(pouchLocation + "buttons/middle/"));
        builder.addAll(this.addAllColours(pouchLocation + "buttons/right/"));
    }

    private List<ResourceLocation> addAllColours(String locationParent) {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        for (EnumColour colour : EnumColour.values()) {
            locations.add(new ResourceLocation(locationParent + colour.getMinecraftName()));
        }
        return locations;
    }

    public IBakedModel bakeModel(String key) {
        Map values = ArrayUtils.convertKeyValueArrayToMap((String[])key.split(","));
        if (!ArrayUtils.containsKeys((Map)values, (Object[])new String[]{"owned", "open", "left", "middle", "right"})) {
            LogHelper.warn("Invalid key for EnderPouch model [%s]!", key);
            return null;
        }
        boolean owned = Boolean.parseBoolean((String)values.get("owned"));
        boolean open = Boolean.parseBoolean((String)values.get("open"));
        String pouchPrefix = Reference.MOD_PREFIX + "items/pouch/";
        String buttonsPrefix = pouchPrefix + "buttons/%s/%s";
        ResourceLocation leftButton = new ResourceLocation(String.format(buttonsPrefix, "left", values.get("left")));
        ResourceLocation middleButton = new ResourceLocation(String.format(buttonsPrefix, "middle", values.get("middle")));
        ResourceLocation rightButton = new ResourceLocation(String.format(buttonsPrefix, "right", values.get("right")));
        ResourceLocation bagLocation = open ? (owned ? new ResourceLocation(pouchPrefix + "owned_open") : new ResourceLocation(pouchPrefix + "open")) : (owned ? new ResourceLocation(pouchPrefix + "owned_closed") : new ResourceLocation(pouchPrefix + "closed"));
        SimplePerspectiveAwareLayerModelBakery correctModel = new SimplePerspectiveAwareLayerModelBakery(bagLocation, new ResourceLocation[]{leftButton, middleButton, rightButton});
        return correctModel.bake((IModelState)TransformUtils.DEFAULT_ITEM);
    }

    public static class EnderStorageKeyProvider
    implements IBakedModelLoader.IModKeyProvider {
        public static final EnderStorageKeyProvider INSTANCE = new EnderStorageKeyProvider();

        public String getMod() {
            return Reference.MOD_PREFIX.replace(":", "");
        }

        public String createKey(ItemStack stack) {
            if (((Object)((Object)ModItems.enderPouch)).equals(stack.func_77973_b())) {
                Frequency frequency = Frequency.fromItemStack(stack);
                EnderItemStorage storage = (EnderItemStorage)EnderStorageManager.instance(true).getStorage(frequency, "item");
                return frequency.toModelLoc() + ",open=" + (storage.openCount() > 0);
            }
            return null;
        }

        public String createKey(IBlockState state) {
            return null;
        }
    }
}

