/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.misc.EnderDyeButton;
import codechicken.enderstorage.misc.EnderKnobSlot;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEnderChest
extends TileFrequencyOwner
implements IInventory {
    public double a_lidAngle;
    public double b_lidAngle;
    public int c_numOpen;
    public int rotation;
    @Deprecated
    private EnderItemStorage storage;
    public static EnderDyeButton[] buttons = new EnderDyeButton[3];

    public TileEnderChest(World world) {
        this.field_145850_b = world;
        this.c_numOpen = -1;
    }

    public TileEnderChest() {
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!(this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L && this.c_numOpen == this.getStorage().getNumOpen())) {
            this.c_numOpen = this.getStorage().getNumOpen();
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.c_numOpen);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
        }
        this.b_lidAngle = this.a_lidAngle;
        this.a_lidAngle = MathHelper.approachLinear((double)this.a_lidAngle, (double)(this.c_numOpen > 0 ? 1.0 : 0.0), (double)0.1);
        if (this.b_lidAngle >= 0.5 && this.a_lidAngle < 0.5) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (this.b_lidAngle == 0.0 && this.a_lidAngle > 0.0) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.c_numOpen = type;
            return true;
        }
        return false;
    }

    public double getRadianLidAngle(float frame) {
        double a = MathHelper.interpolate((double)this.b_lidAngle, (double)this.a_lidAngle, (double)frame);
        a = 1.0 - a;
        a = 1.0 - a * a * a;
        return a * 3.141593 * -0.5;
    }

    @Deprecated
    public void reloadStorage() {
        this.storage = (EnderItemStorage)EnderStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.frequency, "item");
    }

    @Override
    public EnderItemStorage getStorage() {
        return (EnderItemStorage)EnderStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.frequency, "item");
    }

    public int func_70302_i_() {
        return this.getStorage().func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.getStorage().func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.getStorage().func_70298_a(slot, count);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.getStorage().func_70299_a(slot, itemStack);
    }

    @Nonnull
    public String func_70005_c_() {
        return "Ender Chest";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.rotation = packet.readUByte();
    }

    @Override
    public void onPlaced(EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.rotation = tag.func_74771_c("rot");
    }

    @Override
    public boolean activate(EntityPlayer player, int subHit) {
        this.getStorage().openSMPGui(player, "tile.enderChest.name");
        return true;
    }

    public List<IndexedCuboid6> getIndexedCuboids() {
        ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>();
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375)));
        if (this.getRadianLidAngle(0.0f) < 0.0) {
            return cuboids;
        }
        for (int button = 0; button < 3; ++button) {
            EnderDyeButton ebutton = buttons[button].copy();
            ebutton.rotate(0.0, 0.5625, 0.0625, 1.0, 0.0, 0.0, 0.0);
            ebutton.rotateMeta(this.rotation);
            cuboids.add(new IndexedCuboid6((Object)(button + 1), new Cuboid6(ebutton.getMin(), ebutton.getMax())));
        }
        cuboids.add(new IndexedCuboid6((Object)4, new Cuboid6(new EnderKnobSlot(this.rotation).getSelectionBB())));
        return cuboids;
    }

    @Override
    public boolean rotate() {
        if (!this.field_145850_b.field_72995_K) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.func_189518_D_(), (World)this.field_145850_b, (int)(this.field_174879_c.func_177958_n() >> 4), (int)(this.field_174879_c.func_177952_p() >> 4));
        }
        return true;
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    @Override
    public int comparatorInput() {
        return Container.func_94526_b((IInventory)this);
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString("");
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderChest.buttons[i] = new EnderDyeButton(i);
        }
    }
}

