/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.DistanceRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayTracer {
    @Deprecated
    private Vector3 vec = new Vector3();
    @Deprecated
    private Vector3 vec2 = new Vector3();
    @Deprecated
    private Vector3 s_vec = new Vector3();
    @Deprecated
    private double s_dist;
    @Deprecated
    private int s_side;
    @Deprecated
    private IndexedCuboid6 c_cuboid;
    @Deprecated
    private static ThreadLocal<RayTracer> t_inst = new ThreadLocal();

    @Deprecated
    public RayTracer() {
    }

    @Deprecated
    public static RayTracer instance() {
        RayTracer inst = t_inst.get();
        if (inst == null) {
            inst = new RayTracer();
            t_inst.set(inst);
        }
        return inst;
    }

    @Deprecated
    private void traceSide(int side, Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.vec.set(start);
        Vector3 hit = null;
        switch (side) {
            case 0: {
                hit = this.vec.XZintercept(end, cuboid.min.y);
                break;
            }
            case 1: {
                hit = this.vec.XZintercept(end, cuboid.max.y);
                break;
            }
            case 2: {
                hit = this.vec.XYintercept(end, cuboid.min.z);
                break;
            }
            case 3: {
                hit = this.vec.XYintercept(end, cuboid.max.z);
                break;
            }
            case 4: {
                hit = this.vec.YZintercept(end, cuboid.min.x);
                break;
            }
            case 5: {
                hit = this.vec.YZintercept(end, cuboid.max.x);
            }
        }
        if (hit == null) {
            return;
        }
        switch (side) {
            case 0: 
            case 1: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
            case 2: 
            case 3: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y)) break;
                return;
            }
            case 4: 
            case 5: {
                if (MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
        }
        double dist = this.vec2.set(hit).subtract(start).magSquared();
        if (dist < this.s_dist) {
            this.s_side = side;
            this.s_dist = dist;
            this.s_vec.set(this.vec);
        }
    }

    @Deprecated
    private boolean rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.s_dist = Double.MAX_VALUE;
        this.s_side = -1;
        for (int i = 0; i < 6; ++i) {
            this.traceSide(i, start, end, cuboid);
        }
        return this.s_side >= 0;
    }

    @Deprecated
    public IndexedCuboid6 rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids) {
        double c_dist = Double.MAX_VALUE;
        int c_side = 0;
        Vector3 c_vec = Vector3.zero;
        IndexedCuboid6 c_hit = null;
        for (IndexedCuboid6 cuboid : cuboids) {
            if (!this.rayTraceCuboid(start, end, cuboid) || !(this.s_dist < c_dist)) continue;
            c_dist = this.s_dist;
            c_side = this.s_side;
            c_vec = this.s_vec;
            c_hit = cuboid;
        }
        if (c_hit != null) {
            this.s_dist = c_dist;
            this.s_side = c_side;
            this.s_vec = c_vec;
        }
        return c_hit;
    }

    @Deprecated
    public DistanceRayTraceResult rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, BlockCoord pos, Object data) {
        return this.rayTraceCuboid(start, end, cuboid) ? new DistanceRayTraceResult(this.s_vec, this.s_side, pos, data, this.s_dist) : null;
    }

    @Deprecated
    public DistanceRayTraceResult rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, Entity entity, Object data) {
        return this.rayTraceCuboid(start, end, cuboid) ? new DistanceRayTraceResult(entity, this.s_vec, data, this.s_dist) : null;
    }

    @Deprecated
    public DistanceRayTraceResult rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, BlockCoord pos) {
        IndexedCuboid6 hit = this.rayTraceCuboids(start, end, cuboids);
        return hit != null ? new DistanceRayTraceResult(this.s_vec, this.s_side, pos, hit.data, this.s_dist) : null;
    }

    @Deprecated
    public DistanceRayTraceResult rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, Entity entity) {
        IndexedCuboid6 hit = this.rayTraceCuboids(start, end, cuboids);
        return hit != null ? new DistanceRayTraceResult(entity, this.s_vec, hit.data, this.s_dist) : null;
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, List<IndexedCuboid6> cuboids, BlockPos pos) {
        return RayTracer.rayTraceCuboidsClosest(new Vector3(start), new Vector3(end), cuboids, pos);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, BlockPos pos) {
        ArrayList<CuboidRayTraceResult> results = new ArrayList<CuboidRayTraceResult>();
        for (IndexedCuboid6 cuboid6 : cuboids) {
            CuboidRayTraceResult hit = RayTracer.rayTrace(pos, start, end, cuboid6);
            results.add(hit);
        }
        CuboidRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (CuboidRayTraceResult hit : results) {
            if (hit == null || !(curClosest > hit.dist)) continue;
            closestHit = hit;
            curClosest = hit.dist;
        }
        return closestHit;
    }

    public static CuboidRayTraceResult rayTrace(BlockPos pos, Vector3 start, Vector3 end, IndexedCuboid6 cuboid) {
        Vector3 startRay = start.copy().sub(pos);
        Vector3 endRay = end.copy().sub(pos);
        RayTraceResult bbResult = cuboid.aabb().func_72327_a(startRay.vec3(), endRay.vec3());
        if (bbResult != null) {
            Vector3 hitVec = new Vector3(bbResult.field_72307_f).add(pos);
            EnumFacing sideHit = bbResult.field_178784_b;
            double dist = hitVec.copy().sub(start).magSquared();
            return new CuboidRayTraceResult(hitVec, pos, sideHit, cuboid, dist);
        }
        return null;
    }

    public static RayTraceResult retraceBlock(World world, EntityPlayer player, BlockPos pos) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player);
        return world.func_180495_p(pos).func_185910_a(world, pos, startVec, endVec);
    }

    private static double getBlockReachDistance_server(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    public static RayTraceResult retrace(EntityPlayer player) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player);
        return player.field_70170_p.func_147447_a(startVec, endVec, true, false, true);
    }

    public static Vec3d getCorrectedHeadVec(EntityPlayer player) {
        Vector3 v = Vector3.fromEntity((Entity)player).add(0.0, player.func_70047_e(), 0.0);
        return v.vec3();
    }

    public static Vec3d getStartVec(EntityPlayer player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? RayTracer.getBlockReachDistance_client() : (player instanceof EntityPlayerMP ? RayTracer.getBlockReachDistance_server((EntityPlayerMP)player) : 5.0);
    }

    public static Vec3d getEndVec(EntityPlayer player) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }
}

