/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.baked;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.EnumDrawMode;
import codechicken.lib.render.baked.CCBakedQuad;
import codechicken.lib.render.baked.IBakedVertexOperation;
import codechicken.lib.render.uv.UVTransformation;
import codechicken.lib.vec.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class CCBakedModel {
    private final VertexFormat format;
    private final EnumDrawMode drawMode;
    private final CCBakedQuad[] quads;

    public CCBakedModel(CCBakedQuad ... quads) {
        this.quads = quads;
        this.format = this.quads[0].getFormat();
        this.drawMode = this.quads[0].getDrawMode();
    }

    public void render(IBakedVertexOperation ... transformations) {
        this.render(0, this.quads.length, transformations);
    }

    public void render(int start, int end, IBakedVertexOperation ... transformations) {
        boolean shouldStop = false;
        if (!CCRenderState.isDrawing()) {
            shouldStop = true;
            CCRenderState.startDrawing(this.drawMode.getDrawMode(), this.format);
        }
        CCRenderState.setVertexRange(start, end);
        for (CCRenderState.vertexIndex = CCRenderState.firstVertexIndex; CCRenderState.vertexIndex < CCRenderState.lastVertexIndex; ++CCRenderState.vertexIndex) {
            CCBakedQuad quad = this.quads[CCRenderState.vertexIndex];
            CCRenderState.vert.set(quad.getVertex());
            CCRenderState.normal.set(quad.getNormal());
            CCRenderState.normalActive = true;
            CCRenderState.setColour(quad.getColour());
            CCRenderState.brightness = quad.getLightMap();
            for (IBakedVertexOperation transform : transformations) {
                transform.operateBaked();
            }
            CCRenderState.writeVert();
        }
        if (shouldStop) {
            CCRenderState.draw();
        }
    }

    public CCBakedModel apply(Transformation t) {
        for (CCBakedQuad quad : this.quads) {
            quad.getVertex().apply(t);
            if (quad.getNormal() == null) continue;
            t.applyN(quad.getNormal());
        }
        return this;
    }

    public CCBakedModel apply(UVTransformation t) {
        for (CCBakedQuad quad : this.quads) {
            quad.getVertex().apply(t);
        }
        return this;
    }

    public static CCBakedModel combine(CCBakedModel ... models) {
        ArrayList<CCBakedQuad[]> quadArrays = new ArrayList<CCBakedQuad[]>();
        for (CCBakedModel model : models) {
            quadArrays.add(model.quads);
        }
        CCBakedQuad[] combinedQuads = CCBakedModel.combineQuads((CCBakedQuad[][])quadArrays.toArray((T[])new CCBakedQuad[0][]));
        if (!CCBakedModel.validateQuads(combinedQuads)) {
            throw new RuntimeException("Unable to combine quads across VertexFormats!");
        }
        return new CCBakedModel(combinedQuads);
    }

    private static CCBakedQuad[] combineQuads(CCBakedQuad[] ... quadArrays) {
        LinkedList quads = new LinkedList();
        for (CCBakedQuad[] quadArray : quadArrays) {
            Collections.addAll(quads, quadArray);
        }
        return quads.toArray(new CCBakedQuad[quads.size()]);
    }

    public static boolean validateQuads(CCBakedQuad ... quads) {
        return CCBakedModel.validateQuads(quads[0].getFormat(), quads[0].getDrawMode(), quads);
    }

    public static boolean validateQuads(VertexFormat format, EnumDrawMode drawMode, CCBakedQuad ... quads) {
        for (CCBakedQuad quad : quads) {
            if (format.equals((Object)quad.getFormat()) && drawMode.equals((Object)quad.getDrawMode())) continue;
            return false;
        }
        return true;
    }
}

