/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.interfaces;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.tileentity.TileEntity;
import vswe.stevesfactory.blocks.ConnectionBlock;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.blocks.WorldCoordinate;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.interfaces.ContainerBase;
import vswe.stevesfactory.network.PacketHandler;

public class ContainerManager
extends ContainerBase {
    private TileEntityManager manager;
    private EntityPlayer player;
    private List<FlowComponent> oldComponents;
    private List<WorldCoordinate> oldInventories;
    private int oldIdIndexToRemove;

    public ContainerManager(TileEntityManager manager, InventoryPlayer player) {
        super(manager, player);
        this.manager = manager;
        this.player = player.field_70458_d;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e((double)this.manager.func_174877_v().func_177958_n(), (double)this.manager.func_174877_v().func_177956_o(), (double)this.manager.func_174877_v().func_177952_p()) <= 64.0;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.oldComponents != null) {
            boolean hasInventoriesChanged;
            if (this.oldIdIndexToRemove < this.manager.getRemovedIds().size()) {
                int idToRemove = this.manager.getRemovedIds().get(this.oldIdIndexToRemove);
                ++this.oldIdIndexToRemove;
                this.manager.removeFlowComponent(idToRemove, this.oldComponents);
                PacketHandler.sendRemovalPacket(this, idToRemove);
            }
            for (int i = 0; i < this.manager.getFlowItems().size(); ++i) {
                if (i >= this.oldComponents.size()) {
                    PacketHandler.sendNewFlowComponent(this, this.manager.getFlowItems().get(i));
                    this.oldComponents.add(this.manager.getFlowItems().get(i).copy());
                    continue;
                }
                this.oldComponents.get(i).refreshData(this, this.manager.getFlowItems().get(i));
            }
            boolean bl = hasInventoriesChanged = this.oldInventories.size() != this.manager.getConnectedInventories().size();
            if (!hasInventoriesChanged) {
                for (int i = 0; i < this.oldInventories.size(); ++i) {
                    TileEntity tileEntity = this.manager.getConnectedInventories().get(i).getTileEntity();
                    if (!this.oldInventories.get(i).equals(new WorldCoordinate(tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p()))) continue;
                    hasInventoriesChanged = true;
                    break;
                }
            }
            if (hasInventoriesChanged) {
                this.oldInventories.clear();
                for (ConnectionBlock connection : this.manager.getConnectedInventories()) {
                    this.oldInventories.add(new WorldCoordinate(connection.getTileEntity().func_174877_v().func_177958_n(), connection.getTileEntity().func_174877_v().func_177956_o(), connection.getTileEntity().func_174877_v().func_177952_p()));
                }
                PacketHandler.sendUpdateInventoryPacket(this);
            }
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        PacketHandler.sendAllData(this, listener, this.manager);
        this.oldComponents = new ArrayList<FlowComponent>();
        for (FlowComponent component : this.manager.getFlowItems()) {
            this.oldComponents.add(component.copy());
        }
        this.manager.updateInventories();
        this.oldInventories = new ArrayList<WorldCoordinate>();
        for (ConnectionBlock connection : this.manager.getConnectedInventories()) {
            this.oldInventories.add(new WorldCoordinate(connection.getTileEntity().func_174877_v().func_177958_n(), connection.getTileEntity().func_174877_v().func_177956_o(), connection.getTileEntity().func_174877_v().func_177952_p()));
        }
        this.oldIdIndexToRemove = this.manager.getRemovedIds().size();
    }
}

