/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.Tier;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityGasTank
extends TileEntityContainerBlock
implements IGasHandler,
ITubeConnection,
IRedstoneControl,
ISideConfiguration,
ISecurityTile,
ITierUpgradeable {
    public GasTank gasTank;
    public Tier.GasTankTier tier = Tier.GasTankTier.BASIC;
    public GasMode dumping;
    public int currentGasAmount;
    public int currentRedstoneLevel;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.GAS, TransmissionType.ITEM);
    public TileComponentSecurity securityComponent;

    public TileEntityGasTank() {
        super("GasTank");
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Fill", EnumColor.DARK_BLUE, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Empty", EnumColor.DARK_RED, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{2, 1, 0, 0, 0, 0});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.setIOConfig(TransmissionType.GAS);
        this.configComponent.setEjecting(TransmissionType.GAS, true);
        this.gasTank = new GasTank(this.tier.storage);
        this.inventory = new ItemStack[2];
        this.dumping = GasMode.IDLE;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.ejectorComponent = new TileComponentEjector(this);
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            int newGasAmount;
            if (this.inventory[0] != null && this.gasTank.getGas() != null) {
                this.gasTank.draw(GasTransmission.addGas(this.inventory[0], this.gasTank.getGas()), this.tier != Tier.GasTankTier.CREATIVE);
            }
            if (this.inventory[1] != null && (this.gasTank.getGas() == null || this.gasTank.getGas().amount < this.gasTank.getMaxGas())) {
                this.gasTank.receive(GasTransmission.removeGas(this.inventory[1], this.gasTank.getGasType(), this.gasTank.getNeeded()), true);
                if (this.tier == Tier.GasTankTier.CREATIVE && this.gasTank.getGas() != null) {
                    this.gasTank.getGas().amount = Integer.MAX_VALUE;
                }
            }
            if (this.gasTank.getGas() != null && MekanismUtils.canFunction(this) && (this.tier == Tier.GasTankTier.CREATIVE || this.dumping != GasMode.DUMPING) && this.configComponent.isEjecting(TransmissionType.GAS)) {
                GasStack toSend = new GasStack(this.gasTank.getGas().getGas(), Math.min(this.gasTank.getStored(), this.tier.output));
                this.gasTank.draw(GasTransmission.emit(toSend, this, this.configComponent.getSidesForData(TransmissionType.GAS, this.facing, 2)), this.tier != Tier.GasTankTier.CREATIVE);
            }
            if (this.tier != Tier.GasTankTier.CREATIVE) {
                if (this.dumping == GasMode.DUMPING) {
                    this.gasTank.draw(this.tier.storage / 400, true);
                }
                if (this.dumping == GasMode.DUMPING_EXCESS && this.gasTank.getNeeded() < this.tier.output) {
                    this.gasTank.draw(this.tier.output - this.gasTank.getNeeded(), true);
                }
            }
            if ((newGasAmount = this.gasTank.getStored()) != this.currentGasAmount) {
                MekanismUtils.saveChunk(this);
            }
            this.currentGasAmount = newGasAmount;
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.func_70296_d();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    @Override
    public boolean upgrade(Tier.BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = Tier.GasTankTier.values()[upgradeTier.ordinal()];
        this.gasTank.setMaxGas(this.tier.storage);
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
        this.func_70296_d();
        return true;
    }

    @Override
    public String func_70005_c_() {
        return LangUtils.localize("tile.GasTank" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas((ItemStack)itemstack).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.gasTank.getGas() == null || ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, this.gasTank.getGas().getGas()));
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.gasTank.getGas() == null || ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, this.gasTank.getGas().getGas()));
        }
        return false;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.tier == Tier.GasTankTier.CREATIVE) {
            return stack != null ? stack.amount : 0;
        }
        return this.gasTank.receive(stack, doTransfer);
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.gasTank.canDraw(type);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.configComponent.getSidesForData(TransmissionType.GAS, this.facing, 1).contains(side)) {
            return this.gasTank.canReceive(type);
        }
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                int index = (this.dumping.ordinal() + 1) % GasMode.values().length;
                this.dumping = GasMode.values()[index];
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            Tier.GasTankTier prevTier = this.tier;
            this.tier = Tier.GasTankTier.values()[dataStream.readInt()];
            this.gasTank.setMaxGas(this.tier.storage);
            if (dataStream.readBoolean()) {
                this.gasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.gasTank.setGas(null);
            }
            this.dumping = GasMode.values()[dataStream.readInt()];
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            if (prevTier != this.tier) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = Tier.GasTankTier.values()[nbtTags.func_74762_e("tier")];
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.dumping = GasMode.values()[nbtTags.func_74762_e("dumping")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("dumping", this.dumping.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        return nbtTags;
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        data.add(this.dumping.ordinal());
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return true;
    }

    public int getRedstoneLevel() {
        double fractionFull = (float)this.gasTank.getStored() / (float)this.gasTank.getMaxGas();
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    public static enum GasMode {
        IDLE,
        DUMPING_EXCESS,
        DUMPING;

    }
}

