/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.model.bakery.CCQuadBakery;
import codechicken.lib.render.uv.UV;
import java.util.LinkedList;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

public class BlockModelBakery {
    public boolean flipTexture;
    public boolean renderFromInside = false;
    public double renderMinX;
    public double renderMaxX;
    public double renderMinY;
    public double renderMaxY;
    public double renderMinZ;
    public double renderMaxZ;
    public int uvRotateEast;
    public int uvRotateWest;
    public int uvRotateSouth;
    public int uvRotateNorth;
    public int uvRotateTop;
    public int uvRotateBottom;
    public Colour colourTopLeft = new ColourRGBA(-1);
    public Colour colourBottomLeft = new ColourRGBA(-1);
    public Colour colourBottomRight = new ColourRGBA(-1);
    public Colour colourTopRight = new ColourRGBA(-1);
    private LinkedList<BakedQuad> quadList = new LinkedList();
    private VertexFormat format = DefaultVertexFormats.field_176600_a;

    public void setVertexFormat(VertexFormat format) {
        this.format = format;
    }

    public LinkedList<BakedQuad> getBakedQuads() {
        return new LinkedList<BakedQuad>(this.quadList);
    }

    public void reset() {
        this.quadList.clear();
        this.colourTopLeft = new ColourRGBA(-1);
        this.colourBottomLeft = new ColourRGBA(-1);
        this.colourBottomRight = new ColourRGBA(-1);
        this.colourTopRight = new ColourRGBA(-1);
        this.uvRotateEast = 0;
        this.uvRotateWest = 0;
        this.uvRotateSouth = 0;
        this.uvRotateNorth = 0;
        this.uvRotateTop = 0;
        this.uvRotateBottom = 0;
        this.flipTexture = false;
        this.renderFromInside = false;
        this.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void setRenderBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.renderMinX = minX;
        this.renderMaxX = maxX;
        this.renderMinY = minY;
        this.renderMaxY = maxY;
        this.renderMinZ = minZ;
        this.renderMaxZ = maxZ;
    }

    public void bakeFaceYNeg(TextureAtlasSprite sprite) {
        this.bakeFaceYNeg(0.0, 0.0, 0.0, sprite);
    }

    public void bakeFaceYNeg(double posX, double posY, double posZ, TextureAtlasSprite sprite) {
        double d7;
        EnumFacing face = this.renderFromInside ? EnumFacing.UP : EnumFacing.DOWN;
        CCQuadBakery quadBakery = new CCQuadBakery(this.format, sprite, face);
        double d3 = sprite.func_94214_a(this.renderMinX * 16.0);
        double d4 = sprite.func_94214_a(this.renderMaxX * 16.0);
        double d5 = sprite.func_94207_b(this.renderMinZ * 16.0);
        double d6 = sprite.func_94207_b(this.renderMaxZ * 16.0);
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = sprite.func_94209_e();
            d4 = sprite.func_94212_f();
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d5 = sprite.func_94206_g();
            d6 = sprite.func_94210_h();
        }
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateBottom == 2) {
            d3 = sprite.func_94214_a(this.renderMinZ * 16.0);
            d5 = sprite.func_94207_b(16.0 - this.renderMaxX * 16.0);
            d4 = sprite.func_94214_a(this.renderMaxZ * 16.0);
            d6 = sprite.func_94207_b(16.0 - this.renderMinX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateBottom == 1) {
            d3 = sprite.func_94214_a(16.0 - this.renderMaxZ * 16.0);
            d5 = sprite.func_94207_b(this.renderMinX * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMinZ * 16.0);
            d6 = sprite.func_94207_b(this.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateBottom == 3) {
            d3 = sprite.func_94214_a(16.0 - this.renderMinX * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMaxX * 16.0);
            d5 = sprite.func_94207_b(16.0 - this.renderMinZ * 16.0);
            d6 = sprite.func_94207_b(16.0 - this.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = posX + this.renderMinX;
        double d12 = posX + this.renderMaxX;
        double d13 = posY + this.renderMinY;
        double d14 = posZ + this.renderMinZ;
        double d15 = posZ + this.renderMaxZ;
        if (this.renderFromInside) {
            d11 = posX + this.renderMaxX;
            d12 = posX + this.renderMinX;
        }
        UV uv1 = new UV(d8, d10);
        UV uv2 = new UV(d3, d5);
        UV uv3 = new UV(d7, d9);
        UV uv4 = new UV(d4, d6);
        quadBakery.putVertex(d11, d13, d15, uv1, this.colourTopLeft);
        quadBakery.putVertex(d11, d13, d14, uv2, this.colourBottomLeft);
        quadBakery.putVertex(d12, d13, d14, uv3, this.colourBottomRight);
        quadBakery.putVertex(d12, d13, d15, uv4, this.colourTopRight);
        this.quadList.add(quadBakery.bake());
    }

    public void bakeFaceYPos(TextureAtlasSprite sprite) {
        this.bakeFaceYPos(0.0, 0.0, 0.0, sprite);
    }

    public void bakeFaceYPos(double posX, double posY, double posZ, TextureAtlasSprite sprite) {
        double d7;
        EnumFacing face = this.renderFromInside ? EnumFacing.DOWN : EnumFacing.UP;
        CCQuadBakery quadBakery = new CCQuadBakery(this.format, sprite, face);
        double d3 = sprite.func_94214_a(this.renderMinX * 16.0);
        double d4 = sprite.func_94214_a(this.renderMaxX * 16.0);
        double d5 = sprite.func_94207_b(this.renderMinZ * 16.0);
        double d6 = sprite.func_94207_b(this.renderMaxZ * 16.0);
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = sprite.func_94209_e();
            d4 = sprite.func_94212_f();
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d5 = sprite.func_94206_g();
            d6 = sprite.func_94210_h();
        }
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateTop == 1) {
            d3 = sprite.func_94214_a(this.renderMinZ * 16.0);
            d5 = sprite.func_94207_b(16.0 - this.renderMaxX * 16.0);
            d4 = sprite.func_94214_a(this.renderMaxZ * 16.0);
            d6 = sprite.func_94207_b(16.0 - this.renderMinX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateTop == 2) {
            d3 = sprite.func_94214_a(16.0 - this.renderMaxZ * 16.0);
            d5 = sprite.func_94207_b(this.renderMinX * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMinZ * 16.0);
            d6 = sprite.func_94207_b(this.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateTop == 3) {
            d3 = sprite.func_94214_a(16.0 - this.renderMinX * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMaxX * 16.0);
            d5 = sprite.func_94207_b(16.0 - this.renderMinZ * 16.0);
            d6 = sprite.func_94207_b(16.0 - this.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = posX + this.renderMinX;
        double d12 = posX + this.renderMaxX;
        double d13 = posY + this.renderMaxY;
        double d14 = posZ + this.renderMinZ;
        double d15 = posZ + this.renderMaxZ;
        if (this.renderFromInside) {
            d11 = posX + this.renderMaxX;
            d12 = posX + this.renderMinX;
        }
        UV uv1 = new UV(d4, d6);
        UV uv2 = new UV(d7, d9);
        UV uv3 = new UV(d3, d5);
        UV uv4 = new UV(d8, d10);
        quadBakery.putVertex(d12, d13, d15, uv1, this.colourTopLeft);
        quadBakery.putVertex(d12, d13, d14, uv2, this.colourBottomLeft);
        quadBakery.putVertex(d11, d13, d14, uv3, this.colourBottomRight);
        quadBakery.putVertex(d11, d13, d15, uv4, this.colourTopRight);
        this.quadList.add(quadBakery.bake());
    }

    public void bakeFaceZNeg(TextureAtlasSprite sprite) {
        this.bakeFaceZNeg(0.0, 0.0, 0.0, sprite);
    }

    public void bakeFaceZNeg(double posX, double posY, double posZ, TextureAtlasSprite sprite) {
        double d7;
        EnumFacing face = this.renderFromInside ? EnumFacing.SOUTH : EnumFacing.NORTH;
        CCQuadBakery quadBakery = new CCQuadBakery(this.format, sprite, face);
        double d3 = sprite.func_94214_a(this.renderMinX * 16.0);
        double d4 = sprite.func_94214_a(this.renderMaxX * 16.0);
        double d5 = sprite.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double d6 = sprite.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = sprite.func_94209_e();
            d4 = sprite.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = sprite.func_94206_g();
            d6 = sprite.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateEast == 2) {
            d3 = sprite.func_94214_a(this.renderMinY * 16.0);
            d4 = sprite.func_94214_a(this.renderMaxY * 16.0);
            d5 = sprite.func_94207_b(16.0 - this.renderMinX * 16.0);
            d6 = sprite.func_94207_b(16.0 - this.renderMaxX * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateEast == 1) {
            d3 = sprite.func_94214_a(16.0 - this.renderMaxY * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMinY * 16.0);
            d5 = sprite.func_94207_b(this.renderMaxX * 16.0);
            d6 = sprite.func_94207_b(this.renderMinX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateEast == 3) {
            d3 = sprite.func_94214_a(16.0 - this.renderMinX * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMaxX * 16.0);
            d5 = sprite.func_94207_b(this.renderMaxY * 16.0);
            d6 = sprite.func_94207_b(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = posX + this.renderMinX;
        double d12 = posX + this.renderMaxX;
        double d13 = posY + this.renderMinY;
        double d14 = posY + this.renderMaxY;
        double d15 = posZ + this.renderMinZ;
        if (this.renderFromInside) {
            d11 = posX + this.renderMaxX;
            d12 = posX + this.renderMinX;
        }
        UV uv1 = new UV(d7, d9);
        UV uv2 = new UV(d3, d5);
        UV uv3 = new UV(d8, d10);
        UV uv4 = new UV(d4, d6);
        quadBakery.putVertex(d11, d14, d15, uv1, this.colourTopLeft);
        quadBakery.putVertex(d12, d14, d15, uv2, this.colourBottomLeft);
        quadBakery.putVertex(d12, d13, d15, uv3, this.colourBottomRight);
        quadBakery.putVertex(d11, d13, d15, uv4, this.colourTopRight);
        this.quadList.add(quadBakery.bake());
    }

    public void bakeFaceZPos(TextureAtlasSprite sprite) {
        this.bakeFaceZPos(0.0, 0.0, 0.0, sprite);
    }

    public void bakeFaceZPos(double posX, double posY, double posZ, TextureAtlasSprite sprite) {
        double d7;
        EnumFacing face = this.renderFromInside ? EnumFacing.NORTH : EnumFacing.SOUTH;
        CCQuadBakery quadBakery = new CCQuadBakery(this.format, sprite, face);
        double d3 = sprite.func_94214_a(this.renderMinX * 16.0);
        double d4 = sprite.func_94214_a(this.renderMaxX * 16.0);
        double d5 = sprite.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double d6 = sprite.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinX < 0.0 || this.renderMaxX > 1.0) {
            d3 = sprite.func_94209_e();
            d4 = sprite.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = sprite.func_94206_g();
            d6 = sprite.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateWest == 1) {
            d3 = sprite.func_94214_a(this.renderMinY * 16.0);
            d6 = sprite.func_94207_b(16.0 - this.renderMinX * 16.0);
            d4 = sprite.func_94214_a(this.renderMaxY * 16.0);
            d9 = d5 = (double)sprite.func_94207_b(16.0 - this.renderMaxX * 16.0);
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateWest == 2) {
            d3 = sprite.func_94214_a(16.0 - this.renderMaxY * 16.0);
            d5 = sprite.func_94207_b(this.renderMinX * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMinY * 16.0);
            d6 = sprite.func_94207_b(this.renderMaxX * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateWest == 3) {
            d3 = sprite.func_94214_a(16.0 - this.renderMinX * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMaxX * 16.0);
            d5 = sprite.func_94207_b(this.renderMaxY * 16.0);
            d6 = sprite.func_94207_b(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = posX + this.renderMinX;
        double d12 = posX + this.renderMaxX;
        double d13 = posY + this.renderMinY;
        double d14 = posY + this.renderMaxY;
        double d15 = posZ + this.renderMaxZ;
        if (this.renderFromInside) {
            d11 = posX + this.renderMaxX;
            d12 = posX + this.renderMinX;
        }
        UV uv1 = new UV(d3, d5);
        UV uv2 = new UV(d8, d10);
        UV uv3 = new UV(d4, d6);
        UV uv4 = new UV(d7, d9);
        quadBakery.putVertex(d11, d14, d15, uv1, this.colourTopLeft);
        quadBakery.putVertex(d11, d13, d15, uv2, this.colourBottomLeft);
        quadBakery.putVertex(d12, d13, d15, uv3, this.colourBottomRight);
        quadBakery.putVertex(d12, d14, d15, uv4, this.colourTopRight);
        this.quadList.add(quadBakery.bake());
    }

    public void bakeFaceXNeg(TextureAtlasSprite sprite) {
        this.bakeFaceXNeg(0.0, 0.0, 0.0, sprite);
    }

    public void bakeFaceXNeg(double posX, double posY, double posZ, TextureAtlasSprite sprite) {
        double d7;
        EnumFacing face = this.renderFromInside ? EnumFacing.EAST : EnumFacing.WEST;
        CCQuadBakery quadBakery = new CCQuadBakery(this.format, sprite, face);
        double d3 = sprite.func_94214_a(this.renderMinZ * 16.0);
        double d4 = sprite.func_94214_a(this.renderMaxZ * 16.0);
        double d5 = sprite.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double d6 = sprite.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d3 = sprite.func_94209_e();
            d4 = sprite.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = sprite.func_94206_g();
            d6 = sprite.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateNorth == 1) {
            d3 = sprite.func_94214_a(this.renderMinY * 16.0);
            d5 = sprite.func_94207_b(16.0 - this.renderMaxZ * 16.0);
            d4 = sprite.func_94214_a(this.renderMaxY * 16.0);
            d6 = sprite.func_94207_b(16.0 - this.renderMinZ * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateNorth == 2) {
            d3 = sprite.func_94214_a(16.0 - this.renderMaxY * 16.0);
            d5 = sprite.func_94207_b(this.renderMinZ * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMinY * 16.0);
            d6 = sprite.func_94207_b(this.renderMaxZ * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateNorth == 3) {
            d3 = sprite.func_94214_a(16.0 - this.renderMinZ * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMaxZ * 16.0);
            d5 = sprite.func_94207_b(this.renderMaxY * 16.0);
            d6 = sprite.func_94207_b(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = posX + this.renderMinX;
        double d12 = posY + this.renderMinY;
        double d13 = posY + this.renderMaxY;
        double d14 = posZ + this.renderMinZ;
        double d15 = posZ + this.renderMaxZ;
        if (this.renderFromInside) {
            d14 = posZ + this.renderMaxZ;
            d15 = posZ + this.renderMinZ;
        }
        UV uv1 = new UV(d7, d9);
        UV uv2 = new UV(d3, d5);
        UV uv3 = new UV(d8, d10);
        UV uv4 = new UV(d4, d6);
        quadBakery.putVertex(d11, d13, d15, uv1, this.colourTopLeft);
        quadBakery.putVertex(d11, d13, d14, uv2, this.colourBottomLeft);
        quadBakery.putVertex(d11, d12, d14, uv3, this.colourBottomRight);
        quadBakery.putVertex(d11, d12, d15, uv4, this.colourTopRight);
        this.quadList.add(quadBakery.bake());
    }

    public void bakeFaceXPos(TextureAtlasSprite sprite) {
        this.bakeFaceXPos(0.0, 0.0, 0.0, sprite);
    }

    public void bakeFaceXPos(double posX, double posY, double posZ, TextureAtlasSprite sprite) {
        double d7;
        EnumFacing face = this.renderFromInside ? EnumFacing.WEST : EnumFacing.EAST;
        CCQuadBakery quadBakery = new CCQuadBakery(this.format, sprite, face);
        double d3 = sprite.func_94214_a(this.renderMinZ * 16.0);
        double d4 = sprite.func_94214_a(this.renderMaxZ * 16.0);
        double d5 = sprite.func_94207_b(16.0 - this.renderMaxY * 16.0);
        double d6 = sprite.func_94207_b(16.0 - this.renderMinY * 16.0);
        if (this.flipTexture) {
            d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (this.renderMinZ < 0.0 || this.renderMaxZ > 1.0) {
            d3 = sprite.func_94209_e();
            d4 = sprite.func_94212_f();
        }
        if (this.renderMinY < 0.0 || this.renderMaxY > 1.0) {
            d5 = sprite.func_94206_g();
            d6 = sprite.func_94210_h();
        }
        d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateSouth == 2) {
            d3 = sprite.func_94214_a(this.renderMinY * 16.0);
            d5 = sprite.func_94207_b(16.0 - this.renderMinZ * 16.0);
            d4 = sprite.func_94214_a(this.renderMaxY * 16.0);
            d6 = sprite.func_94207_b(16.0 - this.renderMaxZ * 16.0);
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateSouth == 1) {
            d3 = sprite.func_94214_a(16.0 - this.renderMaxY * 16.0);
            d5 = sprite.func_94207_b(this.renderMaxZ * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMinY * 16.0);
            d6 = sprite.func_94207_b(this.renderMinZ * 16.0);
            d7 = d4;
            d8 = d3;
            d3 = d4;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateSouth == 3) {
            d3 = sprite.func_94214_a(16.0 - this.renderMinZ * 16.0);
            d4 = sprite.func_94214_a(16.0 - this.renderMaxZ * 16.0);
            d5 = sprite.func_94207_b(this.renderMaxY * 16.0);
            d6 = sprite.func_94207_b(this.renderMinY * 16.0);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = posX + this.renderMaxX;
        double d12 = posY + this.renderMinY;
        double d13 = posY + this.renderMaxY;
        double d14 = posZ + this.renderMinZ;
        double d15 = posZ + this.renderMaxZ;
        if (this.renderFromInside) {
            d14 = posZ + this.renderMaxZ;
            d15 = posZ + this.renderMinZ;
        }
        UV uv1 = new UV(d8, d10);
        UV uv2 = new UV(d4, d6);
        UV uv3 = new UV(d7, d9);
        UV uv4 = new UV(d3, d5);
        quadBakery.putVertex(d11, d12, d15, uv1, this.colourTopLeft);
        quadBakery.putVertex(d11, d12, d14, uv2, this.colourBottomLeft);
        quadBakery.putVertex(d11, d13, d14, uv3, this.colourBottomRight);
        quadBakery.putVertex(d11, d13, d15, uv4, this.colourTopRight);
        this.quadList.add(quadBakery.bake());
    }
}

