/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

public enum EnumDrawMode {
    POINTS(0),
    LINES(1),
    LINE_LOOP(2),
    LINE_STRIP(3),
    TRIANGLES(4),
    TRIANGLE_STRIP(5),
    TRIANGLE_FAN(6),
    QUADS(7),
    QUAD_STRIP(8),
    POLYGON(9);

    private int glMode;

    private EnumDrawMode(int glMode) {
        this.glMode = glMode;
    }

    public static EnumDrawMode fromGL(int glMode) {
        for (EnumDrawMode drawMode : EnumDrawMode.values()) {
            if (drawMode.getDrawMode() != glMode) continue;
            return drawMode;
        }
        return QUADS;
    }

    public int getDrawMode() {
        return this.glMode;
    }

    public String toString() {
        String mode;
        String name = "DrawMode: ";
        switch (this) {
            case POINTS: {
                mode = "Points";
                break;
            }
            case LINES: {
                mode = "Lines";
                break;
            }
            case LINE_LOOP: {
                mode = "Line Loop";
                break;
            }
            case LINE_STRIP: {
                mode = "Line Strip";
                break;
            }
            case TRIANGLES: {
                mode = "Triangles";
                break;
            }
            case TRIANGLE_STRIP: {
                mode = "Triangle Strip";
                break;
            }
            case TRIANGLE_FAN: {
                mode = "Triangle Fan";
                break;
            }
            case QUADS: {
                mode = "Quads";
                break;
            }
            case QUAD_STRIP: {
                mode = "Quad Strip";
                break;
            }
            case POLYGON: {
                mode = "Polygon";
                break;
            }
            default: {
                mode = "UNKNOWN";
            }
        }
        return name + mode;
    }
}

