/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayUtils {
    public static String[] arrayToLowercase(String[] array) {
        String[] copy = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            copy[i] = array[i].toLowerCase();
        }
        return copy;
    }

    public static Map<String, String> convertKeyValueArrayToMap(String[] array) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : array) {
            String[] split = entry.split("=");
            map.put(split[0], split[1]);
        }
        return map;
    }

    public static boolean containsKeys(Map<String, String> map, Object ... keys) {
        for (Object object : keys) {
            if (map.containsKey(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> void addToArrayFirstNull(T[] array, T value) {
        int nullIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            T v = array[i];
            if (v != null) continue;
            nullIndex = i;
            break;
        }
        if (nullIndex == -1) {
            throw new RuntimeException("Unable to add to array as it is full! Expand it before adding to it!");
        }
        array[nullIndex] = value;
    }

    public static <T> List<T> addAllNoNull(T[] array, List<T> list) {
        for (T value : array) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static <T> boolean isEmpty(T[] array) {
        for (T value : array) {
            if (value == null) continue;
            return false;
        }
        return true;
    }
}

