/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.multipart;

import java.util.EnumSet;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import scala.collection.mutable.StringBuilder;

public class PartState {
    public final IBlockState state;
    public final IBlockState extendedState;
    public final EnumSet<BlockRenderLayer> renderLayers;
    public final ResourceLocation modelPath;

    public PartState(IBlockState state, IBlockState extendedState, EnumSet<BlockRenderLayer> renderLayers, ResourceLocation modelPath) {
        this.state = state;
        this.extendedState = extendedState;
        this.renderLayers = renderLayers;
        this.modelPath = modelPath;
    }

    public static PartState fromPart(IMultipart part) {
        ResourceLocation path = part.getModelPath();
        if (path == null) {
            return null;
        }
        EnumSet<BlockRenderLayer> renderLayers = EnumSet.noneOf(BlockRenderLayer.class);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (!part.canRenderInLayer(layer)) continue;
            renderLayers.add(layer);
        }
        IBlockState state = part.getActualState(MultipartRegistry.getDefaultState(part).func_177621_b());
        IBlockState extendedState = part.getExtendedState(state);
        return new PartState(state, extendedState, renderLayers, path);
    }

    public int hashCode() {
        return this.state.hashCode() + (this.renderLayers != null ? this.renderLayers.hashCode() << 7 : 0) + (this.modelPath != null ? this.modelPath.hashCode() << 15 : 0);
    }

    public String toString() {
        return new StringBuilder().append("(state=").append((Object)this.state).append(", extendedState=").append((Object)this.extendedState).append(", renderLayers=").append(this.renderLayers).append(", modelPath=").append((Object)this.modelPath).append(")").toString();
    }
}

