/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.components.CheckBox;
import vswe.stevesfactory.interfaces.GuiManager;

public class CheckBoxList {
    public static final int CHECK_BOX_SIZE = 8;
    private static final int CHECK_BOX_SRC_X = 42;
    private static final int CHECK_BOX_SRC_Y = 106;
    private static final int CHECK_BOX_TEXT_X = 12;
    private static final int CHECK_BOX_TEXT_Y = 2;
    private List<CheckBox> checkBoxes = new ArrayList<CheckBox>();

    public void addCheckBox(CheckBox checkBox) {
        this.checkBoxes.add(checkBox);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        for (CheckBox checkBox : this.checkBoxes) {
            if (!checkBox.isVisible()) continue;
            int srcCheckBoxX = checkBox.getValue() ? 1 : 0;
            int srcCheckBoxY = CollisionHelper.inBounds(checkBox.getX(), checkBox.getY(), 8, 8, mX, mY) ? 1 : 0;
            gui.drawTexture(checkBox.getX(), checkBox.getY(), 42 + srcCheckBoxX * 8, 106 + srcCheckBoxY * 8, 8, 8);
            if (checkBox.getName() == null) continue;
            gui.drawSplitString(checkBox.getName(), checkBox.getX() + 12, checkBox.getY() + 2, checkBox.getTextWidth(), 0.7f, 0x404040);
        }
    }

    public void onClick(int mX, int mY) {
        for (CheckBox checkBox : this.checkBoxes) {
            if (!checkBox.isVisible() || !CollisionHelper.inBounds(checkBox.getX(), checkBox.getY(), 8, 8, mX, mY)) continue;
            checkBox.setValue(!checkBox.getValue());
            checkBox.onUpdate();
            break;
        }
    }
}

