/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core;

import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zornco.bedcraftbeyond.core.ModContent;
import zornco.bedcraftbeyond.core.Recipes;
import zornco.bedcraftbeyond.core.TabMain;
import zornco.bedcraftbeyond.core.commands.CommandBedcraft;
import zornco.bedcraftbeyond.core.config.ConfigHelper;
import zornco.bedcraftbeyond.core.gui.GuiHandler;
import zornco.bedcraftbeyond.core.network.Registration;
import zornco.bedcraftbeyond.core.proxy.CommonProxy;
import zornco.bedcraftbeyond.core.util.ColorHelper;
import zornco.bedcraftbeyond.frames.TabBeds;
import zornco.bedcraftbeyond.frames.registry.FrameLoader;
import zornco.bedcraftbeyond.storage.handling.CapabilityStorageHandler;

@Mod(modid="bedcraftbeyond", name="BedCraft And Beyond", version="2.4.1", acceptedMinecraftVersions="[1.9.4,],[1.10,)", guiFactory="zornco.bedcraftbeyond.core.config.ConfigGuiFactory")
public class BedCraftBeyond {
    public static final String MOD_ID = "bedcraftbeyond";
    public static final String MOD_VERSION = "2.4.1";
    public static final String MOD_NAME = "BedCraft And Beyond";
    @Mod.Instance(value="bedcraftbeyond")
    public static BedCraftBeyond INSTANCE;
    @SidedProxy(clientSide="zornco.bedcraftbeyond.core.proxy.ClientProxy", serverSide="zornco.bedcraftbeyond.core.proxy.ServerProxy")
    public static CommonProxy PROXY;
    public static CreativeTabs MAIN_TAB;
    public static CreativeTabs BEDS_TAB;
    public static Logger LOGGER;
    public static SimpleNetworkWrapper NETWORK;
    public static Configuration CONFIG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHelper.allModConfigsDir = event.getModConfigurationDirectory();
        ConfigHelper.setup();
        MAIN_TAB = new TabMain();
        BEDS_TAB = new TabBeds();
        ColorHelper.initColorList();
        PROXY.registerModels();
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
        Registration.registerMessages();
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        GuiHandler.INSTANCE = new GuiHandler();
        CapabilityStorageHandler.register();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PROXY.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)GuiHandler.INSTANCE);
        long start = System.currentTimeMillis();
        OreDictionary.registerOre((String)"bed", (ItemStack)new ItemStack((Item)ModContent.Items.woodenBed, 1, Short.MAX_VALUE));
        Recipes.addRecipes();
        long elapsedTimeMillis = System.currentTimeMillis() - start;
        LOGGER.info("Generated recipes in " + elapsedTimeMillis + " milliseconds.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        long start = System.currentTimeMillis();
        FrameLoader.compileFrames();
        LOGGER.info("Compiled frame whitelists in " + (System.currentTimeMillis() - start) + " milliseconds.");
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(MOD_ID)) {
            ConfigHelper.refreshConfigs();
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartingEvent ev) {
        ev.registerServerCommand((ICommand)new CommandBedcraft());
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_NAME);
    }
}

