/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.commands.fragments;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import zornco.bedcraftbeyond.core.commands.CommandFragment;
import zornco.bedcraftbeyond.core.commands.FramesCommandsUtils;
import zornco.bedcraftbeyond.core.commands.fragments.FragmentFramesCheck;
import zornco.bedcraftbeyond.core.commands.fragments.FragmentFramesDump;
import zornco.bedcraftbeyond.core.commands.fragments.FragmentFramesEdit;
import zornco.bedcraftbeyond.core.commands.fragments.FragmentFramesModify;
import zornco.bedcraftbeyond.frames.registry.FrameLoader;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelist;

public class FragmentFrames
extends CommandFragment {
    public static void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new CommandException("bedcraftbeyond.errors.no_subcommand", new Object[0]);
        }
        switch (args[1].toLowerCase()) {
            case "list": {
                FragmentFrames.handleList(sender, args);
                break;
            }
            case "edit": {
                FragmentFramesEdit.execute(server, sender, args);
                break;
            }
            case "add": 
            case "remove": {
                FragmentFramesModify.execute(server, sender, args);
                break;
            }
            case "check": {
                FragmentFramesCheck.execute(server, sender, args);
                break;
            }
            case "save": 
            case "dump": {
                FragmentFramesDump.execute(server, sender, args);
                break;
            }
            case "reload": {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.messages.reloadingFrames", new Object[0]));
                FrameLoader.compileFrames();
            }
        }
    }

    public static List<String> getTabOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        switch (args.length) {
            case 2: {
                return CommandBase.func_175762_a((String[])args, (Collection)ImmutableList.of((Object)"add", (Object)"remove", (Object)"check", (Object)"edit", (Object)"reload", (Object)"list", (Object)"save"));
            }
        }
        switch (args[1].toLowerCase()) {
            case "add": 
            case "remove": {
                return FragmentFramesModify.getTabOptions(server, sender, args, pos);
            }
            case "reload": {
                return Collections.emptyList();
            }
            case "check": {
                return FragmentFramesCheck.getTabOptions(server, sender, args, pos);
            }
            case "edit": {
                return FragmentFramesEdit.getTabOptions(server, sender, args, pos);
            }
            case "save": {
                return FragmentFramesDump.getTabOptions(server, sender, args, pos);
            }
            case "list": {
                return CommandBase.func_175762_a((String[])args, FrameRegistry.EnumFrameType.getPossible());
            }
        }
        return Collections.emptyList();
    }

    private static void handleList(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            throw new CommandException("bedcraftbeyond.errors.frames.no_frame_type", new Object[0]);
        }
        FrameRegistry.EnumFrameType type = FramesCommandsUtils.getFrameTypeFromArgs(args, 2);
        if (type == FrameRegistry.EnumFrameType.UNKNOWN) {
            throw new CommandException("bedcraftbeyond.frames.errors.unknown_frame_type", new Object[0]);
        }
        FrameWhitelist frames = FrameRegistry.getFrameWhitelist(type);
        sender.func_145747_a((ITextComponent)new TextComponentString(frames.getTerminalOutput()));
    }
}

