/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.commands.fragments;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import zornco.bedcraftbeyond.core.commands.CommandFragment;
import zornco.bedcraftbeyond.core.commands.FramesCommandsUtils;
import zornco.bedcraftbeyond.core.config.ConfigHelper;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameFile;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelist;

public class FragmentFramesDump
extends CommandFragment {
    public static List<String> getTabOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 3) {
            return CommandBase.func_175762_a((String[])args, FrameRegistry.EnumFrameType.getPossible());
        }
        return Collections.emptyList();
    }

    public static void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            throw new CommandException("nope.jpg", new Object[0]);
        }
        FrameRegistry.EnumFrameType type = FramesCommandsUtils.getFrameTypeFromArgs(args, 2);
        FragmentFramesDump.dumpFrameList(type);
    }

    private static void dumpFrameList(FrameRegistry.EnumFrameType type) throws FrameException {
        FrameWhitelist frames = FrameRegistry.getFrameWhitelist(type);
        ArrayList<FrameFile.FrameEntry> entriesContainer = new ArrayList<FrameFile.FrameEntry>();
        for (ResourceLocation entry : frames.getValidRegistryEntries()) {
            RangeSet<Integer> entryMetas = frames.getEntry(entry).getValidMeta();
            FrameFile.FrameEntry fEntry = new FrameFile.FrameEntry();
            fEntry.key = entry.toString();
            fEntry.type = type.name().toLowerCase();
            ArrayList<Object> entries = new ArrayList<Object>();
            for (Range range : entryMetas.asRanges()) {
                if (range.lowerEndpoint() == range.upperEndpoint()) {
                    entries.add(range.lowerEndpoint());
                    continue;
                }
                entries.add(range.lowerEndpoint() + "-" + range.upperEndpoint());
            }
            fEntry.whitelist = entries.toArray(new Object[entries.size()]);
            entriesContainer.add(fEntry);
        }
        FrameFile f = new FrameFile();
        f.entries = entriesContainer.toArray(new FrameFile.FrameEntry[entriesContainer.size()]);
        Gson gb = new GsonBuilder().setPrettyPrinting().create();
        String json = gb.toJson((Object)f, FrameFile.class);
        File frameFile = Paths.get(ConfigHelper.modConfigDir.getPath(), "frames", type.name().toLowerCase() + ".json").toFile();
        if (!frameFile.exists()) {
            try {
                frameFile.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            FileOutputStream os = new FileOutputStream(frameFile);
            OutputStreamWriter osw = new OutputStreamWriter(os);
            osw.write(json);
            osw.flush();
            osw.close();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

