/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.commands.fragments;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.commands.CommandFragment;
import zornco.bedcraftbeyond.core.commands.FramesCommandsUtils;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelistEntry;

public class FragmentFramesModify
extends CommandFragment {
    public static List<String> getTabOptions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        switch (args.length) {
            case 3: {
                return CommandBase.func_175762_a((String[])args, FrameRegistry.EnumFrameType.getPossible());
            }
            case 4: 
            case 5: 
            case 6: {
                return FragmentFramesModify.getCoordinateArg(args, pos, 4);
            }
            case 7: {
                return ImmutableList.of((Object)"all", (Object)"meta");
            }
        }
        return Collections.emptyList();
    }

    public static void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IBlockState b = FramesCommandsUtils.getBlockstateFromCommand(args, 3, sender);
        FrameRegistry.EnumFrameType type = FramesCommandsUtils.getFrameTypeFromArgs(args, 2);
        if (b == null) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.frames.registry_mod_fail_unknown", new Object[0]));
            return;
        }
        ItemStack is = b.func_177230_c().getPickBlock(b, null, sender.func_130014_f_(), CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)3, (boolean)false), null);
        switch (args[1].toLowerCase()) {
            case "add": {
                FragmentFramesModify.handleAdd(type, b, is, sender, args);
                break;
            }
            case "reset": {
                FrameRegistry.getFrameWhitelist(type).getEntry(b.func_177230_c().getRegistryName()).reset();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.frames.messages.reset_entry_complete", new Object[]{type}));
                break;
            }
            case "remove": 
            case "delete": {
                FragmentFramesModify.handleRemove(type, b, is, sender, args);
            }
        }
    }

    private static void handleAdd(FrameRegistry.EnumFrameType type, IBlockState state, ItemStack item, ICommandSender sender, String[] args) throws CommandException {
        try {
            String modType = args.length < 7 ? "all" : args[6].toLowerCase();
            switch (modType) {
                case "all": {
                    boolean success = FrameRegistry.getFrameWhitelist(type).addEntry(state.func_177230_c().getRegistryName());
                    if (!success) {
                        throw new CommandException("bedcraftbeyond.frames.whitelisted.fail", new Object[]{item.func_82833_r(), type.name().toLowerCase()});
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.frames.whitelisted", new Object[]{item.func_82833_r(), type.name().toLowerCase()}));
                    break;
                }
                case "meta": {
                    boolean success = FrameRegistry.getFrameWhitelist(type).getEntry(state.func_177230_c().getRegistryName()).whitelist(state.func_177230_c().func_176201_c(state));
                    if (!success) {
                        throw new CommandException("bedcraftbeyond.frames.whitelisted.by_meta.fail", new Object[]{item.func_82833_r(), state.func_177230_c().func_176201_c(state), type.name().toLowerCase()});
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.frames.whitelisted.by_meta", new Object[]{item.func_82833_r(), state.func_177230_c().func_176201_c(state), type.name().toLowerCase()}));
                }
            }
        }
        catch (FrameException fe) {
            BedCraftBeyond.LOGGER.error((Object)fe);
            throw new CommandException(fe.getLocalizedMessage(), new Object[0]);
        }
    }

    private static void handleRemove(FrameRegistry.EnumFrameType type, IBlockState state, ItemStack item, ICommandSender sender, String[] args) throws CommandException {
        try {
            String modType = args.length < 7 ? "all" : args[6].toLowerCase();
            switch (modType) {
                case "all": {
                    boolean success = FrameRegistry.getFrameWhitelist(type).removeEntry(state.func_177230_c().getRegistryName());
                    if (!success) {
                        throw new CommandException("bedcraftbeyond.frames.blacklisted.fail", new Object[]{item.func_82833_r(), type.name().toLowerCase()});
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.frames.blacklisted", new Object[]{item.func_82833_r(), type.name().toLowerCase()}));
                    break;
                }
                case "meta": {
                    FrameWhitelistEntry entry = FrameRegistry.getFrameWhitelist(type).getEntry(state.func_177230_c().getRegistryName());
                    boolean success = entry.blacklist(state.func_177230_c().func_176201_c(state));
                    if (!success) {
                        throw new CommandException("bedcraftbeyond.frames.blacklisted.by_meta.fail", new Object[]{item.func_82833_r(), state.func_177230_c().func_176201_c(state), type.name().toLowerCase()});
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.frames.blacklisted.by_meta", new Object[]{item.func_82833_r(), state.func_177230_c().func_176201_c(state), type.name().toLowerCase()}));
                }
            }
        }
        catch (FrameException fe) {
            BedCraftBeyond.LOGGER.error((Object)fe);
            throw new CommandException(fe.getLocalizedMessage(), new Object[0]);
        }
    }
}

