/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.config;

import java.io.File;
import java.nio.file.Paths;
import net.minecraftforge.common.config.Configuration;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.config.ConfigSettings;

public class ConfigHelper {
    private static boolean runConfigDirs;
    public static File modConfigDir;
    public static File allModConfigsDir;

    private static void setupConfigFile() {
        BedCraftBeyond.CONFIG = new Configuration(Paths.get(modConfigDir.getPath(), "bedcraftbeyond.cfg").toFile());
        ConfigHelper.refreshConfigs();
    }

    private static void setupModDirs() {
        File framesDir;
        if (runConfigDirs) {
            return;
        }
        modConfigDir = Paths.get(allModConfigsDir.getPath(), "bedcraftbeyond").toFile();
        if (!modConfigDir.exists()) {
            modConfigDir.mkdir();
        }
        if (!(framesDir = Paths.get(modConfigDir.getPath(), "frames").toFile()).exists()) {
            framesDir.mkdir();
        }
        runConfigDirs = true;
    }

    public static void setup() {
        ConfigHelper.setupModDirs();
        ConfigHelper.setupConfigFile();
    }

    public static void refreshConfigs() {
        ConfigSettings.ADD_OREDICT_WOODEN = BedCraftBeyond.CONFIG.getBoolean("addWoodenFrames", "frames", true, "Add wooden frames from the ore dictionary.");
        ConfigSettings.ADD_OREDICT_STONE = BedCraftBeyond.CONFIG.getBoolean("addStoneFrames", "frames", true, "Add stone frames from the ore dictionary.");
        ConfigSettings.DRAWER_ITEM_LIMIT = BedCraftBeyond.CONFIG.getInt("drawerLimit", "beds", 12, 3, 15, "Number of slots the drawer gives to a bed frame.");
        if (BedCraftBeyond.CONFIG.hasChanged()) {
            BedCraftBeyond.CONFIG.save();
        }
    }
}

