/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import zornco.bedcraftbeyond.core.BedCraftBeyond;

public class GuiUtils {
    private static final int SLOT_SIZE = 18;
    private static final Dimension STANDARD_INVENTORY_SIZE = new Dimension(162, 76);

    public static List<Slot> createSlotGrid(IItemHandler inventory, int start, Dimension gridSize, Point startPos) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        float totalSlots = gridSize.width * gridSize.height;
        Point slotPos = new Point(1, 1);
        try {
            int slot = start;
            while ((float)slot < (float)start + totalSlots) {
                Point slotPosition = new Point();
                slotPosition.x = startPos.x + (slotPos.x - 1) * 18 + 1;
                slotPosition.y = startPos.y + (slotPos.y - 1) * 18 + 1;
                slots.add((Slot)new SlotItemHandler(inventory, slot, slotPosition.x, slotPosition.y));
                ++slotPos.x;
                if (slotPos.x == gridSize.width + 1) {
                    slotPos.x = 1;
                    ++slotPos.y;
                }
                ++slot;
            }
        }
        catch (Exception e) {
            BedCraftBeyond.LOGGER.error((Object)e);
        }
        return slots;
    }

    public static List<Slot> createStandardInventory(EntityPlayer owner, Point position) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        InvWrapper inv = new InvWrapper((IInventory)owner.field_71071_by);
        List<Slot> mainSlots = GuiUtils.createSlotGrid((IItemHandler)inv, 9, new Dimension(9, 3), position);
        slots.addAll(mainSlots);
        position.y += 58;
        List<Slot> hotbar = GuiUtils.createSlotGrid((IItemHandler)inv, 0, new Dimension(9, 1), position);
        slots.addAll(hotbar);
        return slots;
    }

    public static Rectangle getInventoryArea(Point position) {
        return new Rectangle(position, STANDARD_INVENTORY_SIZE);
    }

    public static Rectangle getInventoryAreaCentered(Dimension guiSize, int startY) {
        Point start = new Point(guiSize.width / 2 - GuiUtils.STANDARD_INVENTORY_SIZE.width / 2, startY);
        return new Rectangle(start, STANDARD_INVENTORY_SIZE);
    }

    public static void drawRectangle(Rectangle r, Color c) {
        Gui.func_73734_a((int)r.x, (int)r.y, (int)(r.x + r.width), (int)(r.y + r.height), (int)c.getRGB());
    }
}

