/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.gui.input;

import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import zornco.bedcraftbeyond.dyes.eyedropper.GuiEyedropper;

public class GuiColorNumberEntry
extends GuiTextField {
    private ColorType colorType;

    public GuiColorNumberEntry(GuiEyedropper master, int componentId, ColorType colorType, FontRenderer fontRenderer, Point pos, Dimension size) {
        super(componentId, fontRenderer, pos.getX(), pos.getY(), size.getWidth(), size.getHeight());
        this.colorType = colorType;
        this.func_175207_a(new ColorInputResponder(master));
        this.func_175205_a(input -> input instanceof String && (input.toString().isEmpty() || input.toString().matches("\\d+") && Integer.parseInt(input.toString()) >= 0 && Integer.parseInt(input.toString()) < 256));
    }

    private class ColorInputResponder
    implements GuiPageButtonList.GuiResponder {
        private GuiEyedropper master;

        public ColorInputResponder(GuiEyedropper master) {
            this.master = master;
        }

        public void func_175321_a(int id, boolean value) {
        }

        public void func_175320_a(int id, float value) {
        }

        public void func_175319_a(int id, String value) {
            Color original = this.master.getCurrentColor();
            Color newColor = Color.WHITE;
            try {
                int numValue = GuiColorNumberEntry.this.func_146179_b().isEmpty() ? 0 : Integer.parseInt(GuiColorNumberEntry.this.func_146179_b());
                switch (GuiColorNumberEntry.this.colorType) {
                    case RED: {
                        newColor = new Color(numValue, original.getGreen(), original.getBlue());
                        break;
                    }
                    case GREEN: {
                        newColor = new Color(original.getRed(), numValue, original.getBlue());
                        break;
                    }
                    case BLUE: {
                        newColor = new Color(original.getRed(), original.getGreen(), numValue);
                    }
                }
                this.master.setCurrentColor(newColor);
            }
            catch (NumberFormatException nfe) {
                return;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public static enum ColorType {
        RED,
        GREEN,
        BLUE;

    }
}

