/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.proxy;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.b3d.B3DLoader;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.ModContent;
import zornco.bedcraftbeyond.core.proxy.CommonProxy;
import zornco.bedcraftbeyond.core.util.RenderingHelper;
import zornco.bedcraftbeyond.core.util.TextureHelper;
import zornco.bedcraftbeyond.dyes.DyeColorer;
import zornco.bedcraftbeyond.frames.base.BlockBedBase;
import zornco.bedcraftbeyond.frames.wooden.BlockWoodenBed;
import zornco.bedcraftbeyond.frames.wooden.WoodenBedColorer;
import zornco.bedcraftbeyond.linens.LinenColorer;
import zornco.bedcraftbeyond.rugs.RugColorer;
import zornco.bedcraftbeyond.storage.handling.IStorageHandler;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)ModContent.Blocks.woodenBed, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockBedBase.OCCUPIED, BlockBedBase.HEAD, BlockWoodenBed.SHEETS, BlockWoodenBed.BLANKETS}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModContent.Blocks.stoneBed, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockBedBase.OCCUPIED}).func_178441_a());
        RenderingHelper.registerItemModel(ModContent.Items.scissors);
        for (int i = 0; i < 16; ++i) {
            RenderingHelper.registerItemModel((Item)ModContent.Items.rug, "inventory", i);
        }
        RenderingHelper.registerItemModel(ModContent.BedParts.blanket.getPartItem());
        RenderingHelper.registerItemModel(ModContent.BedParts.sheet.getPartItem());
        RenderingHelper.registerItemModel(ModContent.Items.drawerKey);
        RenderingHelper.registerItemModel((Item)ModContent.Items.stoneBed);
        RenderingHelper.registerItemModel(ModContent.Items.suitcase);
        RenderingHelper.registerItemModel((Item)ModContent.Items.woodenBed, "storage=false,head=true,status=head");
        RenderingHelper.registerItemModel(ModContent.Items.dyeBottle);
        RenderingHelper.registerItemModel(ModContent.Items.eyedropper);
        RenderingHelper.registerItemModel(ModContent.Items.drawer);
        RenderingHelper.registerItemModel(ModContent.Items.reinforcedDrawer);
        B3DLoader.INSTANCE.addDomain("bedcraftbeyond");
    }

    @Override
    public void init() {
        super.init();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        WoodenBedColorer woodenColorer = new WoodenBedColorer();
        itemColors.func_186730_a((IItemColor)woodenColorer, new Item[]{ModContent.Items.woodenBed});
        blockColors.func_186722_a((IBlockColor)woodenColorer, new Block[]{ModContent.Blocks.woodenBed});
        RugColorer rugs = new RugColorer();
        itemColors.func_186730_a((IItemColor)rugs, new Item[]{ModContent.Items.rug});
        DyeColorer dyes = new DyeColorer();
        itemColors.func_186730_a((IItemColor)dyes, new Item[]{ModContent.Items.dyeBottle, ModContent.Items.eyedropper});
        LinenColorer linens = new LinenColorer();
        itemColors.func_186730_a((IItemColor)linens, new Item[]{ModContent.BedParts.blanket.getPartItem(), ModContent.BedParts.sheet.getPartItem()});
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public Color getColorFromTexture(ItemStack stack) {
        try {
            return TextureHelper.getItemTextureColor(stack);
        }
        catch (Exception e) {
            BedCraftBeyond.LOGGER.error("There was an error getting a color from a texture:");
            BedCraftBeyond.LOGGER.error((Object)e);
            return Color.WHITE;
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void openStorage(IStorageHandler handler, BlockPos tilePos, String id) {
        Minecraft mc = Minecraft.func_71410_x();
        TileEntity tile = mc.field_71441_e.func_175625_s(tilePos);
        mc.func_147108_a((GuiScreen)((GuiContainer)handler.getSlotPart(id).createGUI((EntityPlayer)mc.field_71439_g, tile, handler, id)));
    }
}

