/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import zornco.bedcraftbeyond.core.BedCraftBeyond;

public class ColorHelper {
    public static HashMap<Color, String> colorList;

    public static void initColorList() {
        if (colorList != null && !colorList.isEmpty()) {
            return;
        }
        colorList = new HashMap();
        colorList.put(new Color(218, 165, 32), "Goldenrod");
        colorList.put(new Color(64, 224, 208), "Turquoise");
        colorList.put(new Color(238, 130, 238), "Violet");
        colorList.put(new Color(255, 0, 99), "Crimson");
        colorList.put(new Color(0, 166, 88), "Zorn");
        colorList.put(new Color(58, 127, 225), "Xylex");
        colorList.put(new Color(50, 23, 77), "Delenas");
        BedCraftBeyond.LOGGER.info("ColorHelper registered " + colorList.size() + " additional dye colors.");
    }

    public static String getColorNameFromColor(Color color) {
        return ColorHelper.getColorNameFromColor(color, 9001);
    }

    public static String getColorNameFromColor(Color color, int minMSE) {
        Color closestMatch = null;
        for (Color c : colorList.keySet()) {
            int mse = ColorHelper.computeMSE(c, color);
            if (mse >= minMSE) continue;
            minMSE = mse;
            closestMatch = c;
        }
        if (closestMatch != null) {
            return colorList.get(closestMatch);
        }
        return null;
    }

    private static int computeMSE(Color c1, Color c2) {
        return Math.abs(c1.getRed() - c2.getRed()) + Math.abs(c1.getGreen() - c2.getGreen()) + Math.abs(c1.getBlue() - c2.getBlue());
    }

    public static Color getColorFromStack(ItemStack stack) {
        return ColorHelper.getColorFromStack(stack, "color");
    }

    public static Color getColorFromStack(ItemStack stack, String tagName) {
        if (!stack.func_77942_o()) {
            return Color.WHITE;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (!tags.func_74764_b(tagName)) {
            return Color.WHITE;
        }
        if (!tags.func_150297_b(tagName, 10)) {
            try {
                return new Color(tags.func_74762_e(tagName));
            }
            catch (Exception e) {
                return Color.WHITE;
            }
        }
        NBTTagCompound color = tags.func_74775_l(tagName);
        return ColorHelper.getColorFromNBT(color);
    }

    public static Color getColorFromNBT(NBTTagCompound compound) {
        if (compound == null) {
            return Color.WHITE;
        }
        if (!(compound.func_74764_b("r") && compound.func_74764_b("g") && compound.func_74764_b("b"))) {
            return Color.WHITE;
        }
        return new Color(compound.func_74762_e("r"), compound.func_74762_e("g"), compound.func_74762_e("b"));
    }

    public static String getFormattedColorValues(Color c) {
        return TextFormatting.RED + "" + c.getRed() + TextFormatting.WHITE + ", " + TextFormatting.GREEN + c.getGreen() + TextFormatting.WHITE + ", " + TextFormatting.BLUE + c.getBlue() + TextFormatting.RESET;
    }

    public static String getHexFromColor(Color c) {
        return String.format("%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    public static NBTTagCompound getTagForColor(Color c) {
        NBTTagCompound color = new NBTTagCompound();
        color.func_74768_a("r", c.getRed());
        color.func_74768_a("g", c.getGreen());
        color.func_74768_a("b", c.getBlue());
        return color;
    }

    public static Color blendColours(Object o0, Object o1) {
        assert (o0 instanceof Color || o0 instanceof Integer);
        assert (o1 instanceof Color || o1 instanceof Integer);
        Color c0 = o0 instanceof Color ? (Color)o0 : new Color((Integer)o0);
        Color c1 = o1 instanceof Color ? (Color)o1 : new Color((Integer)o1);
        double totalAlpha = c0.getAlpha() + c1.getAlpha();
        double weight0 = (double)c0.getAlpha() / totalAlpha;
        double weight1 = (double)c1.getAlpha() / totalAlpha;
        double r = weight0 * (double)c0.getRed() + weight1 * (double)c1.getRed();
        double g = weight0 * (double)c0.getGreen() + weight1 * (double)c1.getGreen();
        double b = weight0 * (double)c0.getBlue() + weight1 * (double)c1.getBlue();
        double a = Math.max(c0.getAlpha(), c1.getAlpha());
        return new Color((int)r, (int)g, (int)b, (int)a);
    }

    public static Color getAverageColor(BufferedImage bi, Point topLeft, Dimension size) {
        Rectangle area = new Rectangle(topLeft, size);
        return ColorHelper.getAverageColor(bi, area);
    }

    public static Color getAverageColor(BufferedImage bi, Rectangle area) {
        long sumRed = 0L;
        long sumGreen = 0L;
        long sumBlue = 0L;
        for (int x = area.x; x < area.x + area.width; ++x) {
            for (int y = area.y; y < area.y + area.height; ++y) {
                Color pixel = new Color(bi.getRGB(x, y));
                sumRed += (long)pixel.getRed();
                sumGreen += (long)pixel.getGreen();
                sumBlue += (long)pixel.getBlue();
            }
        }
        int areaArea = area.width * area.height;
        return new Color((int)(sumRed / (long)areaArea), (int)(sumGreen / (long)areaArea), (int)(sumBlue / (long)areaArea));
    }
}

