/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.util.ColorHelper;

public class TextureHelper {
    @SideOnly(value=Side.CLIENT)
    public static Color getItemTextureColor(ItemStack item) throws Exception {
        if (item == null || item.func_77973_b() == null) {
            return Color.WHITE;
        }
        try {
            Block b = Block.func_149634_a((Item)item.func_77973_b());
            TextureAtlasSprite icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(Block.func_149634_a((Item)item.func_77973_b()).func_176203_a(item.func_77952_i())).func_177554_e();
            if (!(icon instanceof TextureAtlasSprite)) {
                throw new Exception("Icon for the itemstack is not a valid sprite.");
            }
            if (icon.func_94215_i().equalsIgnoreCase("missingno")) {
                throw new Exception("Icon does not have a valid sprite- seems to be missing.");
            }
            String iconName = icon.func_94215_i();
            String textureDomain = iconName.substring(0, Math.max(0, iconName.indexOf(58) + 1));
            String texturePath = "textures/" + iconName.substring(Math.max(0, iconName.indexOf(":") + 1)) + ".png";
            ResourceLocation resource = new ResourceLocation(textureDomain + texturePath);
            InputStream layer = Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b();
            BufferedImage buffered = ImageIO.read(layer);
            return ColorHelper.getAverageColor(buffered, new Point(0, 0), new Dimension(icon.func_94211_a(), icon.func_94216_b()));
        }
        catch (Exception e) {
            BedCraftBeyond.LOGGER.error((Object)e);
            throw e;
        }
    }
}

