/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.util.items;

import java.awt.Dimension;
import java.awt.Point;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.gui.container.ContainerBlank;
import zornco.bedcraftbeyond.core.util.items.ItemHandlerGridHelper;

public class ItemHandlerCrafting
extends InventoryCrafting
implements IItemHandlerModifiable {
    private ItemStackHandler handler;
    private Dimension size;

    public ItemHandlerCrafting(Dimension size) {
        super((Container)new ContainerBlank(), size.width, size.height);
        this.size = size;
        this.handler = new ItemStackHandler(size.width * size.height);
    }

    public int func_70302_i_() {
        return this.handler.getSlots();
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return this.handler.getStackInSlot(index);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.handler.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack inserted = this.handler.insertItem(slot, stack, simulate);
        try {
            if (!(inserted != null && inserted.field_77994_a >= stack.field_77994_a || simulate)) {
                this.onContentsChanged(slot);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inserted;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted = this.handler.extractItem(slot, amount, simulate);
        if (extracted != null && !simulate) {
            this.onContentsChanged(slot);
        }
        return extracted;
    }

    protected void onContentsChanged(int slot) {
        BedCraftBeyond.LOGGER.debug(String.format("Contents of slot %d changed.", slot));
    }

    public NBTTagCompound serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.handler.deserializeNBT(nbt);
    }

    @Nullable
    public ItemStack func_70463_b(int row, int column) {
        ItemStack stack = ItemHandlerGridHelper.getStackFromPoint(new Point(column, row), this.size, (IItemHandler)this);
        return stack;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return this.handler.extractItem(index, 64, false);
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        return this.handler.extractItem(index, count, false);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.handler.setStackInSlot(index, stack);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        ItemStack remainder = this.handler.insertItem(index, stack, true);
        return remainder == null || remainder.field_77994_a < stack.field_77994_a;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.setStackInSlot(i, null);
        }
    }

    public int func_174923_h() {
        return this.size.height;
    }

    public int func_174922_i() {
        return this.size.width;
    }
}

