/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.core.util.items;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ItemHandlerGridHelper {
    public static ItemStack getStackFromPoint(Point p, Dimension handlerSize, IItemHandler handler) {
        int slot = ItemHandlerGridHelper.getPositionFromPoint(p, handlerSize);
        return handler.getStackInSlot(slot);
    }

    public static int getPositionFromPoint(Point p, Dimension size) {
        return p.x + p.y * size.width;
    }

    private static void doChecks(IItemHandler handler, Dimension handlerSize, Rectangle gridArea) {
        if ((double)handler.getSlots() < gridArea.getWidth() * gridArea.getHeight()) {
            throw new IndexOutOfBoundsException("Grid size too big to traverse.");
        }
        Rectangle handlerSizedWrapped = new Rectangle(new Point(), handlerSize);
        if (!handlerSizedWrapped.contains(gridArea)) {
            throw new IndexOutOfBoundsException("Given grid area is not valid for handler grid.");
        }
    }

    public static int[] getGridIndexes(IItemHandler handler, Dimension handlerSize, Rectangle area) {
        ArrayList<Integer> points = new ArrayList<Integer>();
        ItemHandlerGridHelper.doChecks(handler, handlerSize, area);
        Point startPosition = area.getLocation();
        Point currePosition = new Point(startPosition);
        while (points.size() < area.width * area.height) {
            points.add(ItemHandlerGridHelper.getPositionFromPoint(currePosition, handlerSize));
            currePosition.translate(1, 0);
            if (currePosition.x != area.width + startPosition.x) continue;
            currePosition.x = startPosition.x;
            ++currePosition.y;
        }
        int[] result = points.stream().mapToInt(Integer::intValue).toArray();
        return result;
    }

    public static ItemStack[] getGridItems(IItemHandler handler, Dimension handlerSize, Rectangle area) {
        int[] stackIndexes;
        ItemHandlerGridHelper.doChecks(handler, handlerSize, area);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int slotID : stackIndexes = ItemHandlerGridHelper.getGridIndexes(handler, handlerSize, area)) {
            ItemStack stack = handler.getStackInSlot(slotID);
            stacks.add(stack);
        }
        return stacks.toArray(new ItemStack[stacks.size()]);
    }

    public static IItemHandler getItemsWrapped(IItemHandler handler, Dimension handlerSize, Rectangle area) {
        ItemStack[] stacks = ItemHandlerGridHelper.getGridItems(handler, handlerSize, area);
        return new ItemStackHandler(stacks);
    }
}

