/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.dyes.eyedropper;

import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.vector.Vector2f;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.gui.GuiSized;
import zornco.bedcraftbeyond.core.gui.input.GuiColorNumberEntry;
import zornco.bedcraftbeyond.core.gui.input.GuiColorSlider;
import zornco.bedcraftbeyond.core.util.ColorHelper;
import zornco.bedcraftbeyond.dyes.eyedropper.ItemEyedropper;
import zornco.bedcraftbeyond.dyes.eyedropper.MessageEyedropperUpdate;

public class GuiEyedropper
extends GuiSized {
    private EntityPlayer player;
    private EnumHand hand;
    private ItemStack eyedropper;
    private GuiColorSlider sliderRed;
    private GuiColorSlider sliderGreen;
    private GuiColorSlider sliderBlue;
    private ColorResponder red;
    private ColorResponder green;
    private ColorResponder blue;
    private ColorInputResponder colorBoxResponder;
    private GuiTextField hexBox;
    private GuiTextField redBox;
    private GuiTextField greenBox;
    private GuiTextField blueBox;

    public GuiEyedropper(EntityPlayer player, EnumHand hand, ItemStack eyedropper) {
        this.player = player;
        this.eyedropper = eyedropper;
        this.hand = hand;
        this.red = new ColorResponder(this, "r");
        this.green = new ColorResponder(this, "g");
        this.blue = new ColorResponder(this, "b");
        this.guiSize = new Dimension(360, 150);
        this.colorBoxResponder = new ColorInputResponder(this);
    }

    public void func_146281_b() {
        super.func_146281_b();
        MessageEyedropperUpdate meu = new MessageEyedropperUpdate(this.player, this.hand, ItemEyedropper.getCurrentColor(this.eyedropper).getRGB());
        BedCraftBeyond.NETWORK.sendToServer((IMessage)meu);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Color c = this.getCurrentColor();
        Vector2f sliderPos = new Vector2f((float)this.topLeft.getX(), (float)(this.topLeft.getY() + 35));
        Vector2f sliderSize = new Vector2f(280.0f, 20.0f);
        Dimension textSize = new Dimension(this.guiSize.getWidth() - 5 - (int)sliderSize.getX(), 18);
        this.sliderRed = new GuiColorSlider(1, sliderPos, sliderSize, "Red: ", c.getRed(), this.red);
        this.field_146292_n.add(this.sliderRed);
        this.redBox = new GuiColorNumberEntry(this, 5, GuiColorNumberEntry.ColorType.RED, this.field_146289_q, new Point(this.topLeft.getX() + (int)sliderSize.getX() + 5, (int)sliderPos.getY() + 1), textSize);
        this.redBox.func_146193_g(Color.RED.getRGB());
        sliderPos.y += 22.0f;
        this.sliderGreen = new GuiColorSlider(2, sliderPos, sliderSize, "Green: ", c.getGreen(), this.green);
        this.field_146292_n.add(this.sliderGreen);
        this.greenBox = new GuiColorNumberEntry(this, 6, GuiColorNumberEntry.ColorType.GREEN, this.field_146289_q, new Point(this.topLeft.getX() + (int)sliderSize.getX() + 5, (int)sliderPos.getY() + 1), textSize);
        this.greenBox.func_146193_g(Color.GREEN.getRGB());
        sliderPos.y += 22.0f;
        this.sliderBlue = new GuiColorSlider(3, sliderPos, sliderSize, "Blue: ", c.getBlue(), this.blue);
        this.blueBox = new GuiColorNumberEntry(this, 7, GuiColorNumberEntry.ColorType.BLUE, this.field_146289_q, new Point(this.topLeft.getX() + (int)sliderSize.getX() + 5, (int)sliderPos.getY() + 1), textSize);
        this.blueBox.func_146193_g(Color.BLUE.getRGB());
        this.field_146292_n.add(this.sliderBlue);
        this.hexBox = new GuiTextField(4, this.field_146289_q, this.topLeft.getX() + 10, this.topLeft.getY() + 5, 60, 20);
        this.hexBox.func_146180_a(ColorHelper.getHexFromColor(c));
        this.hexBox.func_146203_f(6);
        this.hexBox.func_175207_a((GuiPageButtonList.GuiResponder)this.colorBoxResponder);
        this.setCurrentColor(this.getCurrentColor());
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(null);
        }
        this.hexBox.func_146201_a(typedChar, keyCode);
        this.redBox.func_146201_a(typedChar, keyCode);
        this.greenBox.func_146201_a(typedChar, keyCode);
        this.blueBox.func_146201_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.hexBox.func_146192_a(mouseX, mouseY, mouseButton);
        this.redBox.func_146192_a(mouseX, mouseY, mouseButton);
        this.greenBox.func_146192_a(mouseX, mouseY, mouseButton);
        this.blueBox.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void drawSizedBackground() {
        Color c = this.getCurrentColor();
        GuiEyedropper.func_73734_a((int)this.topLeft.getX(), (int)this.topLeft.getY(), (int)(this.topLeft.getX() + this.guiSize.getWidth()), (int)(this.topLeft.getY() + 30), (int)c.getRGB());
    }

    @Override
    public void drawSizedForeground() {
        this.hexBox.func_146194_f();
        this.redBox.func_146194_f();
        this.greenBox.func_146194_f();
        this.blueBox.func_146194_f();
    }

    public Color getCurrentColor() {
        ItemStack ed = this.eyedropper;
        return ColorHelper.getColorFromStack(ed);
    }

    public void setCurrentColor(Color c) {
        NBTTagCompound newColorTag = ColorHelper.getTagForColor(c);
        if (!this.eyedropper.func_77942_o()) {
            this.eyedropper.func_77982_d(new NBTTagCompound());
        }
        this.eyedropper.func_77978_p().func_74782_a("color", (NBTBase)newColorTag);
        if (this.hexBox.func_146179_b().length() == 6) {
            this.hexBox.func_146180_a(ColorHelper.getHexFromColor(c));
        }
        this.sliderRed.setValue(c.getRed());
        this.sliderGreen.setValue(c.getGreen());
        this.sliderBlue.setValue(c.getBlue());
        this.redBox.func_146180_a("" + c.getRed());
        this.greenBox.func_146180_a("" + c.getGreen());
        this.blueBox.func_146180_a("" + c.getBlue());
    }

    private class ColorInputResponder
    implements GuiPageButtonList.GuiResponder {
        private GuiEyedropper master;

        public ColorInputResponder(GuiEyedropper master) {
            this.master = master;
        }

        public void func_175321_a(int id, boolean value) {
        }

        public void func_175320_a(int id, float value) {
        }

        public void func_175319_a(int id, String value) {
            boolean valid;
            boolean bl = valid = value.length() == 6 || value.length() == 3;
            if (valid) {
                this.master.hexBox.func_146193_g(Color.WHITE.getRGB());
                try {
                    if (value.length() == 3) {
                        value = String.format("%1$s%1$s%2$s%2$s%3$s%3$s", value.substring(0, 1), value.substring(1, 2), value.substring(2, 3));
                    }
                    Color c = Color.decode("#" + value);
                    this.master.setCurrentColor(c);
                }
                catch (Exception nfe) {
                    BedCraftBeyond.LOGGER.error((Object)nfe);
                }
            } else {
                this.master.hexBox.func_146193_g(Color.RED.getRGB());
            }
        }
    }

    private class ColorResponder
    implements GuiSlider.ISlider {
        private GuiEyedropper master;
        private String key;

        public ColorResponder(GuiEyedropper master, String key) {
            this.master = master;
            this.key = key;
        }

        public void onChangeSliderValue(GuiSlider slider) {
            Color original = this.master.getCurrentColor();
            Color newColor = Color.WHITE;
            switch (this.key) {
                case "r": {
                    newColor = new Color(slider.getValueInt(), original.getGreen(), original.getBlue());
                    break;
                }
                case "g": {
                    newColor = new Color(original.getRed(), slider.getValueInt(), original.getBlue());
                    break;
                }
                case "b": {
                    newColor = new Color(original.getRed(), original.getGreen(), slider.getValueInt());
                }
            }
            this.master.setCurrentColor(newColor);
        }
    }
}

