/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.dyes.eyedropper;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import zornco.bedcraftbeyond.core.util.ColorHelper;

public class MessageEyedropperUpdate
implements IMessage {
    public UUID playerID;
    public EnumHand hand;
    public int color;

    public MessageEyedropperUpdate() {
        this.playerID = null;
        this.hand = EnumHand.MAIN_HAND;
        this.color = 0;
    }

    public MessageEyedropperUpdate(EntityPlayer player, EnumHand hand, int color) {
        this.playerID = player.func_110124_au();
        this.hand = hand;
        this.color = color;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.hand = buf.readByte() == 1 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.color = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerID.toString());
        buf.writeByte(this.hand == EnumHand.MAIN_HAND ? 1 : 0);
        buf.writeInt(this.color);
    }

    public static class Handler
    implements IMessageHandler<MessageEyedropperUpdate, IMessage> {
        public IMessage onMessage(MessageEyedropperUpdate message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            EntityPlayer player = world.func_152378_a(message.playerID);
            ItemStack eyedropper = player.func_184586_b(message.hand);
            if (eyedropper == null) {
                return null;
            }
            if (!eyedropper.func_77942_o()) {
                eyedropper.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound current = eyedropper.func_77978_p();
            current.func_74782_a("color", (NBTBase)ColorHelper.getTagForColor(new Color(message.color)));
            eyedropper.func_77982_d(current);
            return null;
        }
    }
}

