/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.wooden.BlockWoodenBed;
import zornco.bedcraftbeyond.frames.wooden.TileWoodenBed;

public class BedFrameUpdate
implements IMessage {
    private BlockPos pos;
    private ResourceLocation registryName;
    private int metadata;

    public BedFrameUpdate() {
    }

    public BedFrameUpdate(BlockPos pos, ResourceLocation regName, int meta) {
        this.pos = pos;
        this.registryName = regName;
        this.metadata = meta;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.registryName = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.metadata = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.registryName.toString());
        buf.writeInt(this.metadata);
    }

    public static class Handler
    implements IMessageHandler<BedFrameUpdate, IMessage> {
        public IMessage onMessage(BedFrameUpdate message, MessageContext ctx) {
            World w = BedCraftBeyond.PROXY.getClientWorld();
            IBlockState curState = w.func_180495_p(message.pos);
            TileWoodenBed twb = (TileWoodenBed)((BlockWoodenBed)curState.func_177230_c()).getTileForBed((IBlockAccess)w, curState, message.pos);
            if (twb == null) {
                return null;
            }
            try {
                twb.setPlankType(message.registryName, message.metadata, false);
            }
            catch (FrameException e) {
                BedCraftBeyond.LOGGER.error("There was an error setting the plank type on the client.");
                BedCraftBeyond.LOGGER.error((Object)e);
            }
            return null;
        }
    }
}

