/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.base;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeHell;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.frames.base.TileGenericBed;

public abstract class BlockBedBase
extends Block {
    protected Random random = new Random();
    public static PropertyBool HEAD = PropertyBool.func_177716_a((String)"head");
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool OCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    protected static AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);

    public BlockBedBase() {
        super(Material.field_151580_n);
        this.func_149711_c(1.0f);
        this.func_149647_a(BedCraftBeyond.BEDS_TAB);
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        return true;
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)HEAD) == false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HEAD);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HEAD) != false ? new TileGenericBed(world) : null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        BedCraftBeyond.LOGGER.debug("break block");
        super.func_180663_b(worldIn, pos, state);
    }

    protected void onBlockDestroyed(World world, BlockPos pos, IBlockState state) {
        BlockPos other = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING));
        IBlockState stateOther = world.func_180495_p(other);
        if (stateOther.func_177230_c() instanceof BlockBedBase) {
            world.func_175655_b(other, false);
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        this.onBlockDestroyed(worldIn, pos, state);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        BedCraftBeyond.LOGGER.debug("player destroyed");
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        this.onBlockDestroyed(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.onBedActivated(world, pos, state, player);
    }

    protected boolean onBedActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (!((Boolean)state.func_177229_b((IProperty)HEAD)).booleanValue() && (state = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)))).func_177230_c() != this) {
            return true;
        }
        if (worldIn.field_73011_w.func_76567_e() && !(worldIn.func_180494_b(pos) instanceof BiomeHell)) {
            NBTTagCompound tileBackup = new NBTTagCompound();
            TileGenericBed bedTile = (TileGenericBed)((BlockBedBase)state.func_177230_c()).getTileForBed((IBlockAccess)worldIn, state, pos);
            bedTile.func_189515_b(tileBackup);
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                if (this.getPlayerInBed(worldIn, pos) != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]));
                    return true;
                }
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false)), 4);
                bedTile.func_145839_a(tileBackup);
            }
            EntityPlayer.SleepResult status = playerIn.func_180469_a(pos);
            switch (status) {
                case OK: {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(true)), 4);
                    bedTile.func_145839_a(tileBackup);
                    return true;
                }
                case NOT_POSSIBLE_NOW: {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]));
                    break;
                }
                case NOT_SAFE: {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]));
                }
            }
            return true;
        }
        this.doBedExplosion(worldIn, state, pos);
        return true;
    }

    public EntityPlayer getPlayerInBed(World w, BlockPos pos) {
        Vec3i range = new Vec3i(1.0, 0.8, 1.0);
        List playersInRange = w.func_175661_b(EntityPlayer.class, player -> player.func_70608_bn());
        if (playersInRange.size() == 0) {
            return null;
        }
        return (EntityPlayer)playersInRange.get(0);
    }

    protected void doBedExplosion(World world, IBlockState state, BlockPos pos) {
        BlockPos otherHalf;
        world.func_175698_g(pos);
        if (state.func_177230_c().hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
        if (world.func_180495_p(otherHalf = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_177230_c() == this) {
            world.func_175698_g(otherHalf);
        }
        world.func_72885_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos other = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING));
        if (worldIn.func_180495_p(other).func_177230_c() == this) {
            worldIn.func_175655_b(other, !player.field_71075_bZ.field_75098_d);
        }
        if (((Boolean)state.func_177229_b((IProperty)HEAD)).booleanValue() && !player.func_184812_l_()) {
            this.func_176226_b(worldIn, pos, state, -1);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int par3) {
        return (Boolean)state.func_177229_b((IProperty)HEAD) != false ? Item.func_150898_a((Block)this) : null;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{HEAD, FACING, OCCUPIED}, new IUnlistedProperty[0]);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
        state = state.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf((meta & 4) > 0));
        state = state.func_177226_a((IProperty)HEAD, (Comparable)Boolean.valueOf((meta & 8) > 0));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)HEAD)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public TileEntity getTileForBed(IBlockAccess world, IBlockState state, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)HEAD)).booleanValue()) {
            return world.func_175625_s(pos);
        }
        if (!(state.func_177230_c() instanceof BlockBedBase)) {
            return null;
        }
        BlockPos actualTileHolder = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING));
        TileEntity realHolder = world.func_175625_s(actualTileHolder);
        if (realHolder == null || !(realHolder instanceof TileGenericBed)) {
            return null;
        }
        return realHolder;
    }
}

