/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.registry;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.util.TextureHelper;

public abstract class FrameHelper {
    @SideOnly(value=Side.CLIENT)
    public static Color getColorFromPlankType(ResourceLocation rl, int meta) {
        ItemStack fakeItem = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)rl), 1, meta);
        return FrameHelper.getColorFromPlankType(fakeItem);
    }

    @SideOnly(value=Side.CLIENT)
    public static Color getColorFromPlankType(ItemStack stack) {
        try {
            return TextureHelper.getItemTextureColor(stack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Color.WHITE;
        }
    }

    public static NBTTagCompound getFrameTag(ItemStack stack) {
        NBTTagCompound frameTag = new NBTTagCompound();
        frameTag.func_74778_a("frameType", stack.func_77973_b().getRegistryName().toString());
        frameTag.func_74768_a("frameMeta", stack.func_77960_j());
        return frameTag;
    }

    public static ItemStack getItemFromFrameTag(NBTTagCompound compound) {
        if (compound.func_74764_b("frame")) {
            compound = compound.func_74775_l("frame");
        }
        try {
            Block b = Block.func_149684_b((String)compound.func_74779_i("frameType"));
            if (b == null) {
                return null;
            }
            IBlockState state = b.func_176203_a(compound.func_74764_b("frameMeta") ? compound.func_74762_e("frameMeta") : 0);
            ItemStack frameStack = b.getPickBlock(state, null, null, null, null);
            return frameStack;
        }
        catch (Exception e) {
            BedCraftBeyond.LOGGER.error("There was an error trying to get a frame type from NBT.");
            BedCraftBeyond.LOGGER.error((Object)e);
            return null;
        }
    }
}

