/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.registry;

import com.google.common.collect.Range;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.config.ConfigHelper;
import zornco.bedcraftbeyond.core.config.ConfigSettings;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameFile;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelist;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelistEntry;

public class FrameLoader {
    private static void parseFrameFile(FrameFile frames) {
        for (FrameFile.FrameEntry frameEntry : frames.entries) {
            try {
                FrameLoader.parseFrameFileEntry(frameEntry);
            }
            catch (FrameException e) {
                BedCraftBeyond.LOGGER.error(e.getMessage());
            }
        }
    }

    private static void parseFrameFileEntry(FrameFile.FrameEntry entry) throws FrameException {
        if (entry.key == null || entry.key.trim().equalsIgnoreCase("")) {
            return;
        }
        if (entry.type == null) {
            throw new FrameException(I18n.func_74837_a((String)"bedcraftbeyond.frames.errors.parsing.no_type", (Object[])new Object[]{entry.key}));
        }
        FrameRegistry.EnumFrameType type = FrameRegistry.EnumFrameType.parse(entry.type);
        if (type == FrameRegistry.EnumFrameType.UNKNOWN) {
            throw new FrameException(I18n.func_74837_a((String)"bedcraftbeyond.frames.errors.parsing.invalid_type", (Object[])new Object[]{entry.key, entry.type}));
        }
        FrameWhitelist whitelist = FrameRegistry.getFrameWhitelist(type);
        ResourceLocation entryID = new ResourceLocation(entry.key);
        if (!Block.field_149771_c.func_148741_d((Object)entryID)) {
            throw new FrameException(I18n.func_74837_a((String)"bedcraftbeyond.frames.errors.invalid_name", (Object[])new Object[]{entry.key}));
        }
        if (!whitelist.hasEntryFor(entryID)) {
            whitelist.addEntry(entryID);
        }
        try {
            FrameWhitelistEntry wlEntry = whitelist.getEntry(new ResourceLocation(entry.key));
            int added = FrameLoader.whitelistFromEntry(entry, wlEntry);
            int removed = FrameLoader.blacklistFromEntry(entry, wlEntry);
            BedCraftBeyond.LOGGER.info(String.format("Added %s entries and removed %s entries for registry name %s.", added, removed, entry.key));
        }
        catch (FrameException e) {
            BedCraftBeyond.LOGGER.error(e.getMessage());
        }
    }

    private static int whitelistFromEntry(FrameFile.FrameEntry entry, FrameWhitelistEntry whitelistEntry) throws FrameException {
        if (!entry.hasWhitelist()) {
            return 0;
        }
        int added = 0;
        Block b = (Block)Block.field_149771_c.func_82594_a((Object)whitelistEntry.getID());
        for (Object entryItem : entry.whitelist) {
            if (entryItem instanceof String) {
                Pattern p;
                Matcher m;
                String entryString = String.valueOf(entryItem);
                if (entryString.trim().equalsIgnoreCase("all")) {
                    whitelistEntry.reset();
                    ArrayList addedList = new ArrayList();
                    b.func_149666_a(Item.func_150898_a((Block)b), null, addedList);
                    added += addedList.size();
                    break;
                }
                if (!entryString.contains("-") || !(m = (p = Pattern.compile("(?<lower>\\d+)\\-(?<upper>\\d+)")).matcher(entryString)).matches()) continue;
                int lower = Integer.parseInt(m.group("lower"));
                int upper = Integer.parseInt(m.group("upper"));
                Range range = Range.closed((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper));
                whitelistEntry.whitelist((Range<Integer>)range);
                added += upper - lower + 1;
                continue;
            }
            if (entryItem instanceof Number) {
                whitelistEntry.whitelist(((Number)entryItem).intValue());
                continue;
            }
            BedCraftBeyond.LOGGER.info("Unrecognized entry: " + entryItem.toString());
        }
        return added;
    }

    private static int blacklistFromEntry(FrameFile.FrameEntry entry, FrameWhitelistEntry whitelistEntry) throws FrameException {
        if (!entry.hasBlacklist()) {
            return 0;
        }
        int removed = 0;
        Block b = (Block)Block.field_149771_c.func_82594_a((Object)whitelistEntry.getID());
        for (Object entryItem : entry.blacklist) {
            if (entryItem instanceof String) {
                String entryString = String.valueOf(entryItem);
                switch (entryString.toLowerCase()) {
                    case "all": {
                        whitelistEntry.clear();
                        ArrayList addedList = new ArrayList();
                        b.func_149666_a(Item.func_150898_a((Block)b), null, addedList);
                        removed += addedList.size();
                        break;
                    }
                    default: {
                        Pattern p = Pattern.compile("(?<lower>\\d+)\\-(?<upper>\\d+)");
                        Matcher m = p.matcher(entryString);
                        if (!m.matches()) break;
                        int lower = Integer.parseInt(m.group("lower"));
                        int upper = Integer.parseInt(m.group("upper"));
                        Range range = Range.closed((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper));
                        whitelistEntry.blacklist((Range<Integer>)range);
                        break;
                    }
                }
                continue;
            }
            if (!(entryItem instanceof Number)) continue;
            whitelistEntry.blacklist(((Number)entryItem).intValue());
        }
        return removed;
    }

    private static void addFramesFromOredictEntries(FrameRegistry.EnumFrameType type, String oreDictName) {
        for (ItemStack stack : OreDictionary.getOres((String)oreDictName)) {
            if (!(stack.func_77973_b() instanceof ItemBlock)) continue;
            ResourceLocation regName = stack.func_77973_b().getRegistryName();
            if (regName == null) {
                BedCraftBeyond.LOGGER.error("Found a null registry entry trying to add oreDict frames: " + stack.toString() + ". This is a critical issue, report it to the mod author!");
                continue;
            }
            try {
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    FrameRegistry.getFrameWhitelist(type).addEntry(stack.func_77973_b().getRegistryName());
                    continue;
                }
                FrameWhitelistEntry entry = FrameRegistry.getFrameWhitelist(type).getEntry(regName);
                entry.whitelist(stack.func_77960_j());
            }
            catch (FrameException e) {
                BedCraftBeyond.LOGGER.error(e.getMessage());
            }
        }
    }

    public static void tryFrameTypeFileLoad(File file) throws FrameException {
        if (!file.exists()) {
            throw new FrameException("Could not find frame file: " + file.getName());
        }
        try {
            FileReader fr = new FileReader(file);
            FrameFile frames = (FrameFile)new Gson().fromJson((Reader)fr, FrameFile.class);
            FrameLoader.parseFrameFile(frames);
        }
        catch (Exception e) {
            BedCraftBeyond.LOGGER.error("There was an exception trying to load a frame file:");
            BedCraftBeyond.LOGGER.error((Object)e);
        }
    }

    public static void compileFrames() {
        File[] framesFiles;
        Logger l = BedCraftBeyond.LOGGER;
        FrameRegistry.dumpFrameList();
        if (ConfigSettings.ADD_OREDICT_WOODEN || ConfigSettings.ADD_OREDICT_STONE) {
            l.info("Loading frame data from the ore dictionary...");
        }
        if (ConfigSettings.ADD_OREDICT_WOODEN) {
            FrameLoader.addFramesFromOredictEntries(FrameRegistry.EnumFrameType.WOOD, "plankWood");
        }
        if (ConfigSettings.ADD_OREDICT_STONE) {
            FrameLoader.addFramesFromOredictEntries(FrameRegistry.EnumFrameType.STONE, "blockStone");
        }
        l.info("Loading frames from config files..");
        File framesDir = Paths.get(ConfigHelper.modConfigDir.getPath(), "frames").toFile();
        for (File f : framesFiles = framesDir.listFiles()) {
            BedCraftBeyond.LOGGER.info("Trying to load frames from file: " + f.getName());
            try {
                FrameLoader.tryFrameTypeFileLoad(f);
            }
            catch (FrameException e) {
                BedCraftBeyond.LOGGER.error("Error compiling from frame file: " + f.getName());
                BedCraftBeyond.LOGGER.error(e.getMessage());
            }
        }
    }
}

