/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelist;

public class FrameRegistry {
    private FrameWhitelist woodFrames = new FrameWhitelist(EnumFrameType.WOOD);
    private FrameWhitelist stoneFrames = new FrameWhitelist(EnumFrameType.STONE);
    private static FrameRegistry INSTANCE = new FrameRegistry();

    private FrameRegistry() {
    }

    public static void dumpFrameList() {
        FrameRegistry.INSTANCE.woodFrames.resetWhitelist();
        FrameRegistry.INSTANCE.stoneFrames.resetWhitelist();
    }

    public static FrameWhitelist getFrameWhitelist(EnumFrameType type) {
        FrameWhitelist set = null;
        switch (type) {
            case WOOD: {
                set = FrameRegistry.INSTANCE.woodFrames;
                break;
            }
            case STONE: {
                set = FrameRegistry.INSTANCE.stoneFrames;
            }
        }
        return set;
    }

    public static boolean isValidFrameMaterial(EnumFrameType type, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        if (b == null) {
            return false;
        }
        ResourceLocation rl = b.getRegistryName();
        return FrameRegistry.isValidFrameMaterial(type, rl, stack.func_77960_j());
    }

    public static boolean isValidFrameMaterial(EnumFrameType type, ResourceLocation registryName, int meta) {
        FrameWhitelist set = FrameRegistry.getFrameWhitelist(type);
        if (!set.hasEntryFor(registryName)) {
            return false;
        }
        try {
            return set.getEntry(registryName).isWhitelisted(meta);
        }
        catch (FrameException e) {
            return false;
        }
    }

    public static boolean isValidFrameMaterial(EnumFrameType type, IBlockState state) {
        return FrameRegistry.isValidFrameMaterial(type, state.func_177230_c().getRegistryName(), state.func_177230_c().func_176201_c(state));
    }

    public static enum EnumFrameType {
        WOOD,
        STONE,
        UNKNOWN;


        public static List<String> getPossible() {
            ArrayList<String> possible = new ArrayList<String>();
            for (EnumFrameType val : EnumFrameType.values()) {
                if (val == UNKNOWN) continue;
                possible.add(val.name().toLowerCase());
            }
            return possible;
        }

        public static EnumFrameType parse(String type) {
            for (EnumFrameType frameType : EnumFrameType.values()) {
                if (!frameType.name().equalsIgnoreCase(type)) continue;
                return frameType;
            }
            return UNKNOWN;
        }
    }
}

