/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelistEntry;

public class FrameWhitelist {
    private FrameRegistry.EnumFrameType type;
    private HashMap<ResourceLocation, FrameWhitelistEntry> entries;

    public FrameWhitelist(FrameRegistry.EnumFrameType type) {
        this.type = type;
        this.entries = new HashMap();
    }

    public Set<ResourceLocation> getValidRegistryEntries() {
        return this.entries.keySet();
    }

    public String getTerminalOutput() {
        if (this.entries.isEmpty()) {
            return "{{EMPTY}}";
        }
        String output = "";
        for (Map.Entry<ResourceLocation, FrameWhitelistEntry> set : this.entries.entrySet()) {
            output = output + " " + set.getKey() + ": {" + set.getValue().toString() + "},";
        }
        return output.substring(1, output.length() - 1);
    }

    public boolean hasEntryFor(ResourceLocation registryName) {
        return this.entries.containsKey(registryName);
    }

    public FrameWhitelistEntry getEntry(ResourceLocation registryName) throws FrameException {
        if (!this.entries.containsKey(registryName)) {
            throw new FrameException(I18n.func_74837_a((String)"bedcraftbeyond.frames.errors.not_valid_entry", (Object[])new Object[]{registryName}));
        }
        return this.entries.get(registryName);
    }

    public void resetWhitelist() {
        this.entries.clear();
    }

    public boolean addEntry(ResourceLocation registryName) throws FrameException {
        if (this.entries.containsKey(registryName)) {
            throw new FrameException(I18n.func_74837_a((String)"bedcraftbeyond.frames.errors.already_added", (Object[])new Object[]{this.type.name().toLowerCase()}));
        }
        this.entries.put(registryName, new FrameWhitelistEntry(registryName));
        return true;
    }

    public boolean removeEntry(ResourceLocation registryName) {
        if (this.entries.containsKey(registryName)) {
            this.entries.remove(registryName);
            return true;
        }
        return false;
    }
}

