/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.registry;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import zornco.bedcraftbeyond.frames.registry.FrameException;

public class FrameWhitelistEntry {
    private ResourceLocation id;
    private RangeSet<Integer> meta;

    public FrameWhitelistEntry(ResourceLocation id) {
        this.id = id;
        this.meta = TreeRangeSet.create();
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public RangeSet<Integer> getValidMeta() {
        return this.meta;
    }

    public void clear() {
        this.meta.clear();
    }

    public void reset() {
        if (this.id.equals((Object)new ResourceLocation("minecraft:planks"))) {
            this.whitelist((Range<Integer>)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5)));
        } else {
            this.whitelist((Range<Integer>)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(15)));
        }
    }

    public boolean whitelist(int meta) throws FrameException {
        if (meta < 0) {
            throw new FrameException("bedcraftbeyond.frames.errors.invalid_meta", this.id, meta);
        }
        if (meta == Short.MAX_VALUE) {
            this.reset();
            return true;
        }
        if (this.isWhitelisted(meta)) {
            throw new FrameException(I18n.func_74837_a((String)"bedcraftbeyond.frames.errors.already_added_meta", (Object[])new Object[]{this.id, meta, ""}));
        }
        return this.whitelist((Range<Integer>)Range.closed((Comparable)Integer.valueOf(meta), (Comparable)Integer.valueOf(meta)));
    }

    public boolean whitelist(Range<Integer> range) {
        this.meta.add(range);
        return this.isWhitelisted(range);
    }

    public boolean isWhitelisted(int meta) {
        return this.meta.contains((Comparable)Integer.valueOf(meta));
    }

    public boolean isWhitelisted(Range<Integer> range) {
        return this.meta.encloses(range);
    }

    public boolean blacklist(int meta) {
        if (meta == Short.MAX_VALUE) {
            this.clear();
            return true;
        }
        return this.blacklist((Range<Integer>)Range.closed((Comparable)Integer.valueOf(meta), (Comparable)Integer.valueOf(meta)));
    }

    public boolean blacklist(Range<Integer> range) {
        this.meta.remove(range);
        return !this.isWhitelisted(range);
    }

    public int getNumberEntries() {
        int total = 0;
        for (Range range : this.meta.asRanges()) {
            total += range.upperEndpoint() == range.lowerEndpoint() ? 1 : (Integer)range.upperEndpoint() - (Integer)range.lowerEndpoint() + 1;
        }
        return total;
    }
}

