/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.registry.gui.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.input.Mouse;
import zornco.bedcraftbeyond.core.gui.GuiUtils;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelistEntry;
import zornco.bedcraftbeyond.frames.registry.gui.editor.ContainerFrameWhitelistEditor;
import zornco.bedcraftbeyond.frames.registry.gui.editor.EditorList;

public class GuiFrameWhitelistEditor
extends GuiContainer {
    static final Dimension SIZE = new Dimension(460, 300);
    static Rectangle SCROLL_BOUNDS;
    static Rectangle SELECT_BOUNDS;
    static Rectangle INVENT_BOUNDS;
    private GuiScreen lastScreen;
    private EditorList list;
    GuiButton blacklist;
    GuiButton whitelist;
    GuiButton clear;
    GuiButton reset;
    private FrameWhitelistEntry entry;

    public GuiFrameWhitelistEditor(GuiScreen last, FrameWhitelistEntry entry, FrameRegistry.EnumFrameType type) {
        super((Container)new ContainerFrameWhitelistEditor(type, entry.getID(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        this.lastScreen = last;
        this.entry = entry;
        this.field_146999_f = GuiFrameWhitelistEditor.SIZE.width;
        this.field_147000_g = GuiFrameWhitelistEditor.SIZE.height;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        SCROLL_BOUNDS = new Rectangle(GuiFrameWhitelistEditor.SIZE.width / 2, 0, GuiFrameWhitelistEditor.SIZE.width / 2, GuiFrameWhitelistEditor.SIZE.height - 24);
        SELECT_BOUNDS = new Rectangle(0, 0, GuiFrameWhitelistEditor.SIZE.width / 2 - 4, 98);
        INVENT_BOUNDS = GuiUtils.getInventoryAreaCentered(new Dimension(GuiFrameWhitelistEditor.SELECT_BOUNDS.width, 120), GuiFrameWhitelistEditor.SELECT_BOUNDS.y + GuiFrameWhitelistEditor.SELECT_BOUNDS.height + 12);
        int buttonSize = (GuiFrameWhitelistEditor.SIZE.width / 2 - 4) / 2 - 1;
        Rectangle buttonRow1 = new Rectangle(this.field_147003_i, this.field_147009_r + GuiFrameWhitelistEditor.SELECT_BOUNDS.height - 20, GuiFrameWhitelistEditor.SIZE.width / 2 - 4, 20);
        this.whitelist = new GuiButton(0, buttonRow1.x, buttonRow1.y, buttonSize, buttonRow1.height, "Whitelist");
        this.blacklist = new GuiButton(1, buttonRow1.x + buttonSize + 2, buttonRow1.y, buttonSize, buttonRow1.height, "Blacklist");
        this.field_146292_n.add(this.whitelist);
        this.field_146292_n.add(this.blacklist);
        Rectangle translatedScrollArea = new Rectangle(SCROLL_BOUNDS);
        translatedScrollArea.translate(this.field_147003_i, this.field_147009_r);
        this.list = new EditorList(this.entry, translatedScrollArea, this.field_146294_l, this.field_146295_m);
        Rectangle scrollAreaActions = new Rectangle(this.field_147003_i + GuiFrameWhitelistEditor.SCROLL_BOUNDS.x, this.field_147009_r + GuiFrameWhitelistEditor.SCROLL_BOUNDS.y + GuiFrameWhitelistEditor.SCROLL_BOUNDS.height + 4, GuiFrameWhitelistEditor.SCROLL_BOUNDS.width, 20);
        this.clear = new GuiButton(2, scrollAreaActions.x, scrollAreaActions.y, scrollAreaActions.width / 2 - 2, scrollAreaActions.height, "Clear");
        this.reset = new GuiButton(3, scrollAreaActions.x + scrollAreaActions.width / 2 + 3, scrollAreaActions.y, scrollAreaActions.width / 2 - 2, scrollAreaActions.height, "Reset");
        this.field_146292_n.add(this.clear);
        this.field_146292_n.add(this.reset);
        GuiButton cancel = new GuiButton(-1, this.field_147003_i, this.field_147009_r + GuiFrameWhitelistEditor.SIZE.height - 20, 100, 20, I18n.func_150826_b((String)"gui.cancel"));
        this.field_146292_n.add(cancel);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.list.handleMouseInput(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        Point bottomLeft = new Point(0, GuiFrameWhitelistEditor.SIZE.height - 24 - this.field_146289_q.field_78288_b);
        this.field_146289_q.func_175065_a("Editing:", (float)bottomLeft.x, (float)bottomLeft.y, Color.lightGray.getRGB(), true);
        bottomLeft.translate(this.field_146289_q.func_78256_a("Editing: "), 0);
        this.field_146289_q.func_175065_a(this.entry.getID().toString(), (float)bottomLeft.x, (float)bottomLeft.y, Color.ORANGE.getRGB(), true);
        ItemStack item = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (item == null) {
            return;
        }
        Point drawingArea = new Point(SELECT_BOUNDS.getLocation());
        drawingArea.translate(34, 10);
        this.field_146289_q.func_175065_a(item.func_82833_r(), (float)drawingArea.x, (float)drawingArea.y, Color.CYAN.getRGB(), true);
        drawingArea.translate(0, this.field_146289_q.field_78288_b + 4);
        this.field_146289_q.func_175065_a("Metadata: " + item.func_77960_j(), (float)drawingArea.x, (float)drawingArea.y, Color.lightGray.getRGB(), false);
        drawingArea.translate(0, this.field_146289_q.field_78288_b + 2);
        if (!item.func_77973_b().getRegistryName().equals((Object)this.entry.getID())) {
            this.field_146289_q.func_78276_b("INVALID ITEM", drawingArea.x, drawingArea.y, Color.red.getRGB());
        }
        if (this.entry.isWhitelisted(item.func_77960_j())) {
            this.field_146289_q.func_78276_b("Already whitelisted.", drawingArea.x, drawingArea.y, Color.green.getRGB());
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        Rectangle selectDataArea = new Rectangle(SELECT_BOUNDS);
        selectDataArea.height -= 22;
        GuiUtils.drawRectangle(selectDataArea, new Color(0, 0, 0, 100));
        GuiUtils.drawRectangle(new Rectangle(10, 10, 16, 16), new Color(255, 255, 255, 50));
        GuiUtils.drawRectangle(SCROLL_BOUNDS, Color.darkGray);
        for (Slot s : this.field_147002_h.field_75151_b) {
            ItemStack stack;
            if (!s.func_75216_d() || (stack = s.func_75211_c()).func_77973_b().getRegistryName().equals((Object)this.entry.getID())) continue;
            Rectangle slotArea = new Rectangle(s.field_75223_e, s.field_75221_f, 16, 16);
            Color invalidColor = Color.red;
            invalidColor = new Color(invalidColor.getRed(), invalidColor.getGreen(), invalidColor.getBlue(), 100);
            GuiUtils.drawRectangle(slotArea, invalidColor);
        }
        GlStateManager.func_179121_F();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (!button.field_146124_l) {
            return;
        }
        switch (button.field_146127_k) {
            case -1: {
                this.field_146297_k.func_147108_a(this.lastScreen);
                break;
            }
        }
        this.list.actionPerformed(button);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.list.drawScreen(mouseX, mouseY, partialTicks);
    }
}

