/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.registry.gui.list;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelist;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelistEntry;
import zornco.bedcraftbeyond.frames.registry.gui.list.GuiRegistryList;
import zornco.bedcraftbeyond.frames.registry.gui.list.RegistryWhitelistComponent;

public class FrameWhitelistSection {
    static final int NUM_ACROSS = GuiRegistryList.SCROLL_AREA.width / 18;
    private FrameWhitelist whitelist;
    private FrameWhitelistEntry entry;
    private int num_slots;

    FrameWhitelistSection(ResourceLocation id, RegistryWhitelistComponent parent) throws FrameException {
        this.entry = parent.whitelist.getEntry(id);
        this.num_slots = 0;
        this.whitelist = parent.whitelist;
        RangeSet<Integer> metas = this.whitelist.getEntry(id).getValidMeta();
        for (Range metaRange : metas.asRanges()) {
            if (metaRange.lowerEndpoint() == metaRange.upperEndpoint()) {
                ++this.num_slots;
                continue;
            }
            this.num_slots += (Integer)metaRange.upperEndpoint() - (Integer)metaRange.lowerEndpoint() + 1;
        }
    }

    public FrameWhitelistEntry getEntry() {
        return this.entry;
    }

    public void draw(Rectangle slotArea) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        Point drawPointer = new Point(slotArea.getLocation());
        drawPointer.translate(4, 4);
        fr.func_175065_a(this.entry.getID().toString(), (float)drawPointer.x, (float)drawPointer.y, Color.CYAN.getRGB(), true);
        drawPointer.translate(0, fr.field_78288_b + 4);
        fr.func_175065_a("Whitelisted: " + this.num_slots, (float)drawPointer.x, (float)drawPointer.y, Color.lightGray.getRGB(), false);
        drawPointer.translate(0, fr.field_78288_b + 4);
        Item i = (Item)Item.field_150901_e.func_82594_a((Object)this.entry.getID());
        RenderItem ri = Minecraft.func_71410_x().func_175599_af();
        if (i == null) {
            return;
        }
        try {
            for (Range metaRange : this.whitelist.getEntry(this.entry.getID()).getValidMeta().asRanges()) {
                if (metaRange.lowerEndpoint() == metaRange.upperEndpoint()) {
                    ItemStack itemMeta = new ItemStack(i, 1, ((Integer)metaRange.lowerEndpoint()).intValue());
                    ri.func_180450_b(itemMeta, drawPointer.x, drawPointer.y);
                    drawPointer.translate(18, 0);
                    if (drawPointer.x <= slotArea.x + slotArea.width - 17) continue;
                    drawPointer.move(slotArea.x, slotArea.y + 18);
                    continue;
                }
                for (int meta = ((Integer)metaRange.lowerEndpoint()).intValue(); meta < (Integer)metaRange.upperEndpoint() + 1; ++meta) {
                    ItemStack itemMeta = new ItemStack(i, 1, meta);
                    ri.func_180450_b(itemMeta, drawPointer.x, drawPointer.y);
                    drawPointer.translate(18, 0);
                    if (drawPointer.x <= slotArea.x + slotArea.width - 17) continue;
                    drawPointer.move(slotArea.x, slotArea.y + 18);
                }
            }
        }
        catch (FrameException e) {
            e.printStackTrace();
        }
    }
}

