/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.registry.gui.list;

import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.GuiScrollingList;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelist;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelistEntry;
import zornco.bedcraftbeyond.frames.registry.gui.list.FrameWhitelistSection;
import zornco.bedcraftbeyond.frames.registry.gui.list.GuiRegistryList;

public class RegistryWhitelistComponent
extends GuiScrollingList {
    private GuiRegistryList editor;
    FrameWhitelist whitelist;
    private ArrayList<FrameWhitelistSection> sections;

    RegistryWhitelistComponent(GuiRegistryList editor, Minecraft mc, FrameRegistry.EnumFrameType type) {
        super(mc, GuiRegistryList.SCROLL_AREA.width, GuiRegistryList.SCROLL_AREA.height, GuiRegistryList.SCROLL_AREA.y, GuiRegistryList.SCROLL_AREA.y + GuiRegistryList.SCROLL_AREA.height, GuiRegistryList.SCROLL_AREA.x, 60, editor.field_146294_l, editor.field_146295_m);
        this.editor = editor;
        this.sections = new ArrayList();
        this.whitelist = FrameRegistry.getFrameWhitelist(type);
        for (ResourceLocation entry : this.whitelist.getValidRegistryEntries()) {
            try {
                FrameWhitelistSection section = new FrameWhitelistSection(entry, this);
                this.sections.add(section);
            }
            catch (FrameException e) {
                e.printStackTrace();
            }
        }
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        FrameWhitelistSection section = this.sections.get(slotIdx);
        section.draw(new Rectangle(this.left, slotTop, this.listWidth - 7, this.slotHeight));
    }

    protected int getSize() {
        return this.whitelist.getValidRegistryEntries().size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
    }

    protected boolean isSelected(int index) {
        return index == this.selectedIndex;
    }

    public FrameWhitelistEntry getSelectedEntry() {
        return this.sections.get(this.selectedIndex).getEntry();
    }
}

