/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.wooden;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.items.ItemHandlerHelper;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.ModContent;
import zornco.bedcraftbeyond.frames.base.BlockBedBase;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.wooden.EnumWoodenFabricStatus;
import zornco.bedcraftbeyond.frames.wooden.TileWoodenBed;
import zornco.bedcraftbeyond.linens.LinenHandler;
import zornco.bedcraftbeyond.linens.PropertyFabricType;
import zornco.bedcraftbeyond.parts.IPart;
import zornco.bedcraftbeyond.parts.IPartAcceptor;
import zornco.bedcraftbeyond.parts.Part;
import zornco.bedcraftbeyond.storage.handling.CapabilityStorageHandler;
import zornco.bedcraftbeyond.storage.handling.IStorageHandler;
import zornco.bedcraftbeyond.storage.handling.MessageStorageUpdate;
import zornco.bedcraftbeyond.storage.handling.StoragePacketHandler;

public class BlockWoodenBed
extends BlockBedBase
implements IPartAcceptor {
    public static PropertyBool HAS_STORAGE = PropertyBool.func_177716_a((String)"storage");
    public static PropertyEnum<EnumWoodenFabricStatus> STATUS = PropertyEnum.func_177709_a((String)"status", EnumWoodenFabricStatus.class);
    public static PropertyEnum<PropertyFabricType> BLANKETS = PropertyEnum.func_177709_a((String)"color_blankets", PropertyFabricType.class);
    public static PropertyEnum<PropertyFabricType> SHEETS = PropertyEnum.func_177709_a((String)"color_sheets", PropertyFabricType.class);

    public BlockWoodenBed() {
        this.setRegistryName("bedcraftbeyond", "wooden_bed");
        this.func_149663_c("bedcraftbeyond.beds.wooden");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HEAD, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HAS_STORAGE, (Comparable)Boolean.valueOf(false)).func_177226_a(STATUS, (Comparable)((Object)EnumWoodenFabricStatus.FOOT)).func_177226_a(BLANKETS, (Comparable)((Object)PropertyFabricType.NONE)).func_177226_a(SHEETS, (Comparable)((Object)PropertyFabricType.NONE)));
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HEAD, OCCUPIED, FACING, HAS_STORAGE, STATUS, BLANKETS, SHEETS});
    }

    private boolean hasBlanketsAndSheets(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileWoodenBed tile = (TileWoodenBed)this.getTileForBed(world, state, pos);
        return tile.getLinenHandler().hasBothParts();
    }

    @Override
    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        return this.hasBlanketsAndSheets(state, world, pos);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HEAD) != false ? new TileWoodenBed(world) : null;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileWoodenBed tile = (TileWoodenBed)this.getTileForBed((IBlockAccess)world, state, pos);
        if (tile == null) {
            return true;
        }
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        if (heldItem == null) {
            if ((double)hitY < 0.5) {
                String storageID = (Boolean)state.func_177229_b((IProperty)HEAD) != false ? "head" : "foot";
                IStorageHandler handler = tile.getCapability(CapabilityStorageHandler.INSTANCE, side);
                if (!handler.isSlotFilled(storageID)) {
                    return true;
                }
                StoragePacketHandler.openStorage(world, player, tile.func_174877_v(), side, handler, storageID);
                return true;
            }
            if ((double)hitY >= 0.5 && (double)hitY < 0.7 && !player.func_70093_af() && this.hasBlanketsAndSheets(state, (IBlockAccess)world, pos)) {
                this.onBedActivated(world, pos, state, player);
                return true;
            }
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        Part.Type partType = Part.getPartType(heldItem);
        if (partType == Part.Type.INVALID || partType == Part.Type.UNKNOWN) {
            return false;
        }
        if (!this.canAcceptPart(world, state, pos, side, new Vector3f(hitX, hitY, hitZ), heldItem)) {
            return false;
        }
        if (partType == Part.Type.STORAGE && hitY < 0.5f) {
            ItemStack acceptedPart = this.addPart(world, state, pos, side, new Vector3f(hitX, hitY, hitZ), heldItem);
            if (!player.func_184812_l_()) {
                player.func_184611_a(hand, acceptedPart);
            }
            return true;
        }
        if (partType.isLinenPart() && hitY > 0.5f) {
            ItemStack acceptedPart = this.addPart(world, state, pos, side, new Vector3f(hitX, hitY, hitZ), heldItem);
            if (!player.func_184812_l_()) {
                player.func_184611_a(hand, acceptedPart);
            }
            return true;
        }
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.getTileForBed(worldIn, state, pos) == null) {
            return state;
        }
        TileWoodenBed bed = (TileWoodenBed)this.getTileForBed(worldIn, state, pos);
        boolean hl = this.hasBlanketsAndSheets(state, worldIn, pos);
        state = state.func_177226_a(BLANKETS, (Comparable)((Object)bed.getLinenHandler().getLinenType(Part.Type.BLANKETS)));
        state = state.func_177226_a(STATUS, (Comparable)((Object)(((Boolean)(state = state.func_177226_a(SHEETS, (Comparable)((Object)bed.getLinenHandler().getLinenType(Part.Type.SHEETS)))).func_177229_b((IProperty)HEAD)).booleanValue() ? (hl ? EnumWoodenFabricStatus.HEAD_LINENS : EnumWoodenFabricStatus.HEAD) : (hl ? EnumWoodenFabricStatus.FOOT_LINENS : EnumWoodenFabricStatus.FOOT))));
        return state;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack((Block)ModContent.Blocks.woodenBed, 1, 0);
        TileWoodenBed tile = (TileWoodenBed)this.getTileForBed((IBlockAccess)world, state, pos);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("frame", (NBTBase)tile.getPlankData());
        return stack;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (!((Boolean)state.func_177229_b((IProperty)HEAD)).booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack bedItem = new ItemStack((Item)ModContent.Items.woodenBed);
        NBTTagCompound tags = new NBTTagCompound();
        state = this.func_176221_a(state, world, pos);
        TileWoodenBed twb = (TileWoodenBed)this.getTileForBed(world, state, pos);
        NBTTagCompound frameData = twb.getPlankData();
        tags.func_74782_a("frame", (NBTBase)frameData);
        bedItem.func_77982_d(tags);
        drops.add(bedItem);
        LinenHandler linens = twb.getLinenHandler();
        if (linens.getLinenPart(Part.Type.BLANKETS, false) != null) {
            drops.add(linens.getLinenPart(Part.Type.BLANKETS, true));
        }
        if (linens.getLinenPart(Part.Type.SHEETS, false) != null) {
            drops.add(linens.getLinenPart(Part.Type.SHEETS, true));
        }
        drops.addAll((Collection<ItemStack>)twb.storage.getItems());
        return drops;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileWoodenBed twb = (TileWoodenBed)this.getTileForBed((IBlockAccess)worldIn, state, pos);
        if (twb == null) {
            return;
        }
        try {
            NBTTagCompound frame = stack.func_77978_p().func_74775_l("frame");
            twb.setPlankType(frame, true);
        }
        catch (FrameException e) {
            BedCraftBeyond.LOGGER.error("Could not set frame type from item. Invalid whitelist entry.");
            worldIn.func_175655_b(pos, true);
        }
        if (worldIn.field_72995_K) {
            twb.recachePlankColor();
        }
    }

    @Override
    public boolean canAcceptPart(World world, IBlockState state, BlockPos pos, EnumFacing side, Vector3f hit, ItemStack stack) {
        Part.Type type = Part.getPartType(stack);
        if (type.isUnknownOrInvalid()) {
            return false;
        }
        TileWoodenBed twb = (TileWoodenBed)this.getTileForBed((IBlockAccess)world, state, pos);
        switch (type) {
            case STORAGE: {
                if (!twb.hasCapability(CapabilityStorageHandler.INSTANCE, side)) {
                    return false;
                }
                IStorageHandler handler = twb.getCapability(CapabilityStorageHandler.INSTANCE, side);
                return !handler.isSlotFilled((Boolean)state.func_177229_b((IProperty)HEAD) != false ? "head" : "foot");
            }
            case BLANKETS: 
            case SHEETS: {
                return !twb.getLinenHandler().hasLinenPart(type);
            }
        }
        return false;
    }

    @Override
    public ItemStack addPart(World world, IBlockState state, BlockPos pos, EnumFacing side, Vector3f hit, ItemStack stack) {
        if (!this.canAcceptPart(world, state, pos, side, hit, stack)) {
            return stack.func_77946_l();
        }
        Part part = ((IPart)stack.func_77973_b()).getPartReference();
        Part.Type type = part.getPartType();
        TileWoodenBed twb = (TileWoodenBed)this.getTileForBed((IBlockAccess)world, state, pos);
        if (type == Part.Type.STORAGE) {
            String area;
            IStorageHandler handler = twb.getCapability(CapabilityStorageHandler.INSTANCE, side);
            String string = area = (Boolean)state.func_177229_b((IProperty)HEAD) != false ? "head" : "foot";
            if (handler.isSlotFilled(area)) {
                return stack.func_77946_l();
            }
            ItemStack pushed = handler.fillSlot(area, stack);
            if (pushed == null || pushed.field_77994_a < stack.field_77994_a) {
                MessageStorageUpdate update = new MessageStorageUpdate(twb.func_174877_v(), area, side, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                BedCraftBeyond.NETWORK.sendToAllAround((IMessage)update, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 20.0));
            }
            return pushed;
        }
        if (type.isLinenPart()) {
            boolean hasPart = twb.getLinenHandler().hasLinenPart(type);
            if (hasPart) {
                return stack.func_77946_l();
            }
            twb.getLinenHandler().setLinenPart(type, stack);
            twb.updateClients(type);
            if (stack.field_77994_a > 1) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - 1));
            }
            if (stack.field_77994_a == 1) {
                return null;
            }
        }
        return stack.func_77946_l();
    }
}

