/*
 * Decompiled with CFR 0.152.
 */
package zornco.bedcraftbeyond.frames.wooden;

import com.google.common.collect.Range;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import zornco.bedcraftbeyond.core.BedCraftBeyond;
import zornco.bedcraftbeyond.core.ModContent;
import zornco.bedcraftbeyond.core.util.SettingsHelper;
import zornco.bedcraftbeyond.frames.base.BlockBedBase;
import zornco.bedcraftbeyond.frames.base.ItemFrame;
import zornco.bedcraftbeyond.frames.registry.FrameException;
import zornco.bedcraftbeyond.frames.registry.FrameHelper;
import zornco.bedcraftbeyond.frames.registry.FrameRegistry;
import zornco.bedcraftbeyond.frames.registry.FrameWhitelist;

public class ItemWoodenFrame
extends ItemFrame {
    public ItemWoodenFrame(Block b) {
        super(b);
        this.func_77655_b("frames.wooden");
        this.func_77627_a(true);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        FrameWhitelist wood = FrameRegistry.getFrameWhitelist(FrameRegistry.EnumFrameType.WOOD);
        for (ResourceLocation rl : wood.getValidRegistryEntries()) {
            try {
                for (Range r : wood.getEntry(rl).getValidMeta().asRanges()) {
                    if (!r.hasLowerBound() || !r.hasUpperBound()) continue;
                    if (r.lowerEndpoint() == r.upperEndpoint()) {
                        ItemStack stack = new ItemStack((Item)this, 1, 0);
                        stack.func_77982_d(new NBTTagCompound());
                        NBTTagCompound frameTag = new NBTTagCompound();
                        frameTag.func_74778_a("frameType", rl.toString());
                        frameTag.func_74768_a("frameMeta", ((Integer)r.lowerEndpoint()).intValue());
                        stack.func_77978_p().func_74782_a("frame", (NBTBase)frameTag);
                        subItems.add(stack);
                        continue;
                    }
                    for (int curEntry = ((Integer)r.lowerEndpoint()).intValue(); curEntry < (Integer)r.upperEndpoint(); ++curEntry) {
                        ItemStack stack = new ItemStack((Item)this, 1, 0);
                        stack.func_77982_d(new NBTTagCompound());
                        NBTTagCompound frameTag = new NBTTagCompound();
                        frameTag.func_74778_a("frameType", rl.toString());
                        frameTag.func_74768_a("frameMeta", curEntry);
                        stack.func_77978_p().func_74782_a("frame", (NBTBase)frameTag);
                        subItems.add(stack);
                    }
                }
            }
            catch (FrameException e) {
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tags, boolean advanced) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("frame")) {
            tags.add(TextFormatting.RED + I18n.func_135052_a((String)"bedcraftbeyond.frames.errors.invalid_frame", (Object[])new Object[0]));
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        NBTTagCompound frameTag = nbt.func_74775_l("frame");
        ItemStack frameStack = FrameHelper.getItemFromFrameTag(frameTag);
        if (frameStack != null) {
            tags.add(TextFormatting.GREEN + "Frame: " + TextFormatting.RESET + frameStack.func_82833_r());
        }
        if (SettingsHelper.showingAdvancedTooltips()) {
            tags.add(TextFormatting.AQUA + frameTag.func_74779_i("frameType") + ":" + frameTag.func_74762_e("frameMeta"));
            tags.add("");
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("frame")) {
            return EnumActionResult.FAIL;
        }
        NBTTagCompound frame = stack.func_77978_p().func_74775_l("frame");
        FrameWhitelist wood = FrameRegistry.getFrameWhitelist(FrameRegistry.EnumFrameType.WOOD);
        if (!wood.hasEntryFor(new ResourceLocation(frame.func_74779_i("frameType")))) {
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.frames.errors.not_valid_entry", new Object[]{frame.func_74779_i("frameType")}));
            }
            return EnumActionResult.FAIL;
        }
        try {
            if (!wood.getEntry(new ResourceLocation(frame.func_74779_i("frameType"))).isWhitelisted(frame.func_74762_e("frameMeta"))) {
                if (world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("bedcraftbeyond.frames.errors.not_valid_entry", new Object[]{frame.func_74779_i("frameType")}));
                }
                return EnumActionResult.FAIL;
            }
        }
        catch (FrameException e) {
            BedCraftBeyond.LOGGER.error("Internal error: " + e.getMessage());
        }
        boolean canPlaceBedHere = ItemWoodenFrame.testSimpleBedPlacement(world, player, pos, stack);
        if (!canPlaceBedHere) {
            return EnumActionResult.FAIL;
        }
        pos = pos.func_177984_a();
        try {
            BlockPos btmHalf = pos;
            BlockPos topHalf = btmHalf.func_177972_a(player.func_174811_aO());
            IBlockState foot = ModContent.Blocks.woodenBed.func_176223_P().func_177226_a((IProperty)BlockBedBase.FACING, (Comparable)player.func_174811_aO()).func_177226_a((IProperty)BlockBedBase.HEAD, (Comparable)Boolean.valueOf(false));
            if (!this.placeBedBlock(stack, world, player, btmHalf, foot, true)) {
                throw new Exception();
            }
            IBlockState head = ModContent.Blocks.woodenBed.func_176223_P().func_177226_a((IProperty)BlockBedBase.HEAD, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockBedBase.FACING, (Comparable)player.func_174811_aO().func_176734_d());
            if (!this.placeBedBlock(stack, world, player, topHalf, head, true)) {
                throw new Exception("Failed to set blockstate.");
            }
        }
        catch (Exception e) {
            return EnumActionResult.FAIL;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            new PlayerInvWrapper(player.field_71071_by).extractItem(player.field_71071_by.field_70461_c, 1, false);
        }
        return EnumActionResult.SUCCESS;
    }
}

